% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixglasso.R
\name{mixglasso_ncomp_fixed}
\alias{mixglasso_ncomp_fixed}
\title{mixglasso_ncomp_fixed}
\usage{
mixglasso_ncomp_fixed(x, n.comp, lambda = sqrt(2 * nrow(x) *
  log(ncol(x)))/2, pen = "glasso.parcor", init = "kmeans.hc",
  my.cl = NULL, modelname.hc = "VVV", nstart.kmeans = 1,
  iter.max.kmeans = 10, term = 10^{     -3 }, min.compsize = 5, ...)
}
\arguments{
\item{x}{Input data matrix}

\item{n.comp}{Number of mixture components}

\item{lambda}{Regularization parameter. Default=sqrt(2*n*log(p))/2}

\item{pen}{Determines form of penalty: glasso.parcor (default), glasso.invcov, glasso.invcor}

\item{init}{Initialization. Method used for initialization
init={'cl.init','r.means','random','kmeans','kmeans.hc','hc'}. Default='kmeans'}

\item{my.cl}{Initial cluster assignments;
need to be provided if init='cl.init' (otherwise this param is ignored). Default=NULL}

\item{modelname.hc}{Model class used in hc. Default="VVV"}

\item{nstart.kmeans}{Number of random starts in kmeans; default=1}

\item{iter.max.kmeans}{Maximal number of iteration in kmeans; default=10}

\item{term}{Termination criterion of EM algorithm. Default=10^-3}

\item{min.compsize}{Stop EM if any(compsize)<min.compsize; Default=5}

\item{...}{Other arguments. See mixglasso_init}
}
\value{
see return mixglasso_init. list consisting of
\item{mix.prob}{}
\item{Mu}{}
\item{Sig}{}
\item{SigInv}{}
\item{iter}{}
\item{loglik}{}
\item{bic}{-loglik+log(n)*DF/2}
\item{mmdl}{-loglik+penmmdl/2}
\item{u}{responsibilities}
\item{comp}{component assignments}
\item{compsize}{size of components}
\item{pi.comps}{}
\item{warn}{warnings during optimization}
}
\description{
mixglasso_ncomp_fixed
}
\details{
This function runs mixglasso
}
\author{
n.stadler
}
\keyword{internal}
