% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_groups.R
\name{ndex_delete_group}
\alias{ndex_delete_group}
\title{Delete Group}
\usage{
ndex_delete_group(ndexcon, groupId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{groupId}{character; unique ID (UUID) of the group}
}
\value{
NULL if successfull, else an error is thrown
}
\description{
Delete the group specified by groupId
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

DELETE: ndex_config$api$group$delete
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find user and get its id
# user = ndex_find_user_byName(ndexcon, 'MyAccountName')
# userId = user$externalId
## Find the user's groups and get one group id
# groups = ndex_user_list_groups(ndexcon, userId)
# groupId = groups[1,"externalId"]
#ndex_delete_group(ndexcon,groupId)
NULL
}
