% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfFlowSet-accessors.R
\name{replacement method for ncdfFlowSet}
\alias{replacement method for ncdfFlowSet}
\alias{[[<-,ncdfFlowSet,flowFrame-method}
\alias{[[<-,ncdfFlowSet,ANY,ANY,flowFrame-method}
\title{write the flow data from a \code{flowFrame} to \code{ncdfFlowSet}
 
flowFrame can have less channels than ncdfFlowSet,which is used for partial updating(useful for \code{normalization})}
\usage{
\S4method{[[}{ncdfFlowSet,ANY,ANY,flowFrame}(x, i, j = "missing", compress = 0, ...) <- value
}
\arguments{
\item{x}{a \code{ncdfFlowSet}}

\item{i}{a \code{numeric} or \code{character} used as sample index of \code{ncdfFlowSet}}

\item{j}{not used}

\item{compress}{\code{integer} It is only relevant to writing slice to '2d' format because the compression is set during the creation of hdf5 file for '3d' format. see details in \link{read.ncdfFlowset}.}

\item{...}{not used}

\item{value}{\code{flowFrame}}
}
\description{
write the flow data from a \code{flowFrame} to \code{ncdfFlowSet}
 
flowFrame can have less channels than ncdfFlowSet,which is used for partial updating(useful for \code{normalization})
}
\examples{
data(GvHD)
nc <- ncdfFlowSet(GvHD[1:2])
samples <- sampleNames(nc)
sn <- samples[1]
#return the entire flowFrame
fr <- nc[[sn]]  
 
apply(exprs(nc[[sn]]), 2, range)

#transform the data
lgcl <- logicleTransform( w = 0.5, t= 10000, m =4.5)
fr_trans <- transform(fr, `FL1-H` = lgcl(`FL1-H`), `FL2-H` = lgcl(`FL2-H`))

#update the data
nc[[sn]] <- fr_trans
apply(exprs(nc[[sn]]), 2, range)

#subset on channels
nc1 <- nc[,2:3]
#only write the channels of interest (reduce disk IO)
nc1[[sn]] <- fr_trans[,2:3]

#chanel colnames
colnames(fr_trans)[3:4] <- c("<FL1-H>", "<FL2-H>")

#write data without matching up the colnames will fail 
#nc[[sn]] <- fr_trans
}
