% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfIO.R
\name{clone.ncdfFlowSet}
\alias{clone.ncdfFlowSet}
\title{Clone a ncdfFlowSet}
\usage{
clone.ncdfFlowSet(
  ncfs,
  ncdfFile = NULL,
  isEmpty = FALSE,
  isNew = TRUE,
  dim = 2,
  compress = 0
)
}
\arguments{
\item{ncfs}{A \code{\link{ncdfFlowSet}}.}

\item{ncdfFile}{A character scalar giving the output file name. By
default, It is NULL and the function will generate a random
file name, potentially adding the \code{.cdf} suffix unless a file
extension is already present. It is only valid when isNewNcFile=TRUE}

\item{isEmpty}{A logical scalar indicating whether the raw data should also be copied.if FALSE,
an empty cdf file is created with the same dimensions (sample*events*channels) as the orignial one.}

\item{isNew}{A logical scalar indicating whether the new cdf file should be created.
If FALSE, the original cdf file is associated with the new ncdfFlowSet object.}

\item{dim}{\code{integer} see details in \link{read.ncdfFlowset}.}

\item{compress}{\code{integer} see details in \link{read.ncdfFlowset}.}
}
\value{
A ncdfFlowSet object
}
\description{
Create a new ncdfFlowSet object from an existing one
}
\examples{

path<-system.file("extdata","compdata","data",package="flowCore")
files<-list.files(path,full.names=TRUE)[1:3]

#create ncdfFlowSet from fcs
nc1  <- read.ncdfFlowSet(files=files,ncdfFile="ncfsTest.nc",flowSetId="fs1",isWriteSlice= TRUE)

##clone the ncdfFlowSet object
nc2<-clone.ncdfFlowSet(nc1,"clone.nc")
nc2[[1]]

#optionally create the empty hdf file without writting the acutal flow data into it
nc2 <- clone.ncdfFlowSet(nc1,"clone.nc", isEmpty = TRUE)

#add the actual raw data
fs1  <- read.flowSet(files=files)
nc2[[sampleNames(fs1)[1]]] <- fs1[[1]]
nc2[[1]]

#delete the cdf file associated with ncdfFlowSet before removing it from memory
unlink(nc2)
rm(nc2)

unlink(nc1)
rm(nc1)
}
\seealso{
\code{\link{read.ncdfFlowSet}}
}
