% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\docType{methods}
\name{groupInfo,ncGTWinput-method}
\alias{groupInfo,ncGTWinput-method}
\alias{groupInfo}
\alias{profiles,ncGTWinput-method}
\alias{profiles}
\alias{rtRaw,ncGTWinput-method}
\alias{rtRaw}
\alias{scanRange,ncGTWoutput-method}
\alias{scanRange}
\alias{ncGTWpath,ncGTWoutput-method}
\alias{ncGTWpath}
\alias{downSample,ncGTWoutput-method}
\alias{downSample}
\title{ncGTWinput-accessors}
\usage{
\S4method{groupInfo}{ncGTWinput}(object)

\S4method{profiles}{ncGTWinput}(object)

\S4method{rtRaw}{ncGTWinput}(object)

\S4method{scanRange}{ncGTWoutput}(object)

\S4method{ncGTWpath}{ncGTWoutput}(object)

\S4method{downSample}{ncGTWoutput}(object)
}
\arguments{
\item{object}{a \code{\link{ncGTWinput}} object.}
}
\value{
\code{groupInfo} returns a vector of the information of the loaded
feature.

\code{profiles} returns a raw data matrix in which each row is a
sample profile.

\code{rtRaw} returns a raw RT matrix in which each row is the
corresponding sample RT.

\code{scanRange} returns a downsampled RT matrix in which each row is
the corresponding sample RT in \code{data}.

\code{ncGTWpath} returns a list of the same length as the sample
number, in which each element is a matrix of the alignment result of the
corresponding sample.

\code{downSample} returns the factor of downsampling when perform
ncGTW alignment.
}
\description{
Accessors to the feature and profiles loaded by \code{\link{loadProfile}}.
}
\examples{
# obtain data
data('xcmsExamples')
xcmsLargeWin <- xcmsExamples$xcmsLargeWin
xcmsSmallWin <- xcmsExamples$xcmsSmallWin
ppm <- xcmsExamples$ppm

# detect misaligned features
excluGroups <- misalignDetect(xcmsLargeWin, xcmsSmallWin, ppm)

# obtain the paths of the sample files
filepath <- system.file("extdata", package = "ncGTW")
file <- list.files(filepath, pattern="mzxml", full.names=TRUE)

tempInd <- matrix(0, length(file), 1)
for (n in seq_along(file)){
    tempCha <- file[n]
    tempLen <- nchar(tempCha)
    tempInd[n] <- as.numeric(substr(tempCha, regexpr("example", tempCha) + 7,
        tempLen - 6))
}
# sort the paths by data acquisition order
file <- file[sort.int(tempInd, index.return = TRUE)$ix]
\dontrun{
# load the sample profiles
ncGTWinputs <- loadProfile(file, excluGroups)

gInfo <- groupInfo(ncGTWinputs[[1]])
prof <- profiles(ncGTWinputs[[1]])
rtR <- rtRaw(ncGTWinputs[[1]])
}
}
