% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{add_result}
\alias{add_result}
\title{Load an external model into a musica object}
\usage{
add_result(
  signatures,
  exposures,
  musica,
  result_name,
  modality,
  model_id,
  make_copy = FALSE
)
}
\arguments{
\item{signatures}{A matrix or data.frame of signatures by mutational motifs}

\item{exposures}{A matrix or data.frame of samples by signature weights}

\item{musica}{Existing musica object to add the new model to}

\item{result_name}{Name of result list entry to store the model in}

\item{modality}{Modality of the model}

\item{model_id}{Name of model}

\item{make_copy}{If \code{FALSE}, the inputted \code{\linkS4class{musica}}
object is updated and nothing is returned. If \code{TRUE}, a new
\code{\linkS4class{musica}} object is created and returned. Default
\code{FALSE}.}
}
\value{
A \linkS4class{musica} object
}
\description{
This function creates a \linkS4class{result_model} object from signatures,
exposures, and a mutation count table, and stores it in a provided musica
object.
}
\examples{
signatures <- signatures(res, "result", "SBS96", "res")
exposures <- exposures(res, "result", "SBS96", "res")
add_result(signatures, exposures, musica = musica_annot,
result_name = "result", modality = "SBS96", model_id = "example_model")
}
