% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffModuleExpAnalysis.R
\name{runDME}
\alias{runDME}
\title{Run differential module expression}
\usage{
runDME(
  WGCNAobject,
  design,
  alphaLevel = 0.05,
  testCondition = NULL,
  refCondition = NULL,
  p.adjust = "fdr",
  plot = FALSE,
  test = c("ANOVA", "PERMANOVA"),
  write = FALSE,
  out = NULL
)
}
\arguments{
\item{WGCNAobject}{object of class WGCNA with the modules to run DME on}

\item{design}{the sampleTable}

\item{alphaLevel}{level of significance}

\item{testCondition}{the column of the sampleTable to be resolved}

\item{refCondition}{the column of the sampleTable to be used as biological variation}

\item{p.adjust}{adjust for multiple comparisons, argument to pass to p.adjust function}

\item{plot}{generate a plot?}

\item{test}{statistical test to perform, either "ANOVA" or "PERMANOVA"}

\item{write}{write results to a file?}

\item{out}{file name for DME plots, only used if write is TRUE}
}
\value{
a data.frame summarizing the results of the analysis
}
\description{
A wrapper to run diffModuleExpression on all the modules in a network
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_se = eh_query[["EH8223"]]
sampleTable = colData(astrocyte_se)
astrocyte_networks = eh_query[["EH8222"]]
runDME(astrocyte_networks[["combined"]], 
  design = sampleTable,
  p.adjust = "fdr", 
  refCondition = "Region", 
  testCondition = "Disease") 

}
\author{
Dario Tommasini
}
