% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastlo.R
\name{fastlo}
\alias{fastlo}
\title{Perform fast loess normalization on a Hi-C experiment}
\usage{
fastlo(
  hicexp,
  iterations = 3,
  span = 0.7,
  parallel = FALSE,
  verbose = FALSE,
  max.pool = 0.7
)
}
\arguments{
\item{hicexp}{A hicexp object}

\item{iterations}{The number of iterations (cycles) 
for fastlo to proceed through.}

\item{span}{The span of loess fitting. Defaults to 0.7. To
automatically calculate a span using the GCV set 
span = NA. However note that setting span = NA will
significantly slow down the normalization process.}

\item{parallel}{Logical. Should parallel processing be
used?}

\item{verbose}{Logical, should messages about
the normalization be printed?}

\item{max.pool}{The proportion of unit distances after
which all further distances will be pooled. Distances
before this value will be progressively pooled and
any distances after this value will be combined
into a single pool. Defaults to 0.7. Warning: do
not adjust this value from the default unless you
are getting errors related to the lfproc function
or due to sparsity in fastlo normalization. If these
errors occur it is due to either sparsity or low 
variance and max.pool will need to be lowered; 
typically to 0.5 or 0.6.}
}
\value{
A hicexp object that is normalized.
}
\description{
Perform fast loess normalization on a Hi-C experiment
}
\details{
This function performs the fast loess (fastlo)
   normalization procedure on a hicexp object. the fast linear 
   loess ("fastlo") method 
   of Ballman (2004) that is adapted to Hi-C data on a per-distance basis.
    To perform 
   "fastlo" on Hi-C data we first split the data into p pooled matrices. 
   The "progressive pooling" is used to split up the Hi-C matrix by unit 
   distance. Fastlo
   is then performed on the MA plots for each distance pool. 
   See Stansfield et al (2018)
   for full description.
}
\examples{
data("hicexp2")
hicexp2 <- fastlo(hicexp2)
}
