% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msqrobHurdle-methods.R
\name{msqrobHurdle,SummarizedExperiment-method}
\alias{msqrobHurdle,SummarizedExperiment-method}
\alias{msqrobHurdle}
\alias{msqrobHurdle,QFeatures-method}
\title{Function to fit msqrob hurdle models}
\usage{
\S4method{msqrobHurdle}{SummarizedExperiment}(
  object,
  formula,
  modelColumnName = "msqrobHurdle",
  overwrite = FALSE,
  robust = TRUE,
  ridge = FALSE,
  maxitRob = 1,
  tol = 1e-06,
  doQR = TRUE,
  lmerArgs = list(control = lmerControl(calc.derivs = FALSE)),
  priorCount = 0.1,
  binomialBound = TRUE
)

\S4method{msqrobHurdle}{QFeatures}(
  object,
  i,
  formula,
  modelColumnName = "msqrobHurdle",
  overwrite = FALSE,
  robust = TRUE,
  ridge = FALSE,
  maxitRob = 1,
  tol = 1e-06,
  doQR = TRUE,
  lmerArgs = list(control = lmerControl(calc.derivs = FALSE)),
  priorCount = 0.1,
  binomialBound = TRUE
)
}
\arguments{
\item{object}{\code{SummarizedExperiment} or \code{QFeatures} instance with an assay that is generated with the \code{aggreateFeatures} function from the \code{QFeatures} package}

\item{formula}{Model formula. Both model components are built based on the
covariates in the data object.}

\item{modelColumnName}{\code{character} to indicate the variable name that is used
to store the msqrob models in the rowData of the SummarizedExperiment
instance or of the assay of the QFeatures instance. Default is "msqrobHurdle".}

\item{overwrite}{\code{boolean(1)} to indicate if the column in the rowData has to
be overwritten if the modelColumnName already exists. Default is FALSE.}

\item{robust}{\code{boolean(1)} to indicate if robust regression is
performed to account for outliers when fitting the intensity component of
the hurdle model. Default is \code{TRUE}. If \code{FALSE} an OLS fit is performed.}

\item{ridge}{\code{boolean(1)} to indicate if ridge regression is
performed. Default is \code{FALSE}. If \code{TRUE} the fixed effects of the
intensity component of the hurdle model are
estimated via penalized regression and shrunken to zero.}

\item{maxitRob}{\code{numeric(1)} indicating the maximum iterations in
the IRWLS algorithm used in the M-estimation step of the robust
regression for fitting the intensity component of the hurdle model.}

\item{tol}{\code{numeric(1)} indicating the tolerance for declaring convergence
of the M-estimation loop of the intensity component of the hurdle model.}

\item{doQR}{\code{boolean(1)} to indicate if QR decomposition is used when adopting
ridge regression for the intensity component of the model. Default is \code{TRUE}. If \code{FALSE} the predictors of the fixed
effects are not transformed, and the degree of shrinkage can depend on the encoding.}

\item{lmerArgs}{a list (of correct class, resulting from ‘lmerControl()’
containing control parameters, including the nonlinear optimizer to be used
and parameters to be passed through to the nonlinear optimizer, see the
‘lmerControl’ documentation of the lme4 package for more details.
Default is \code{list(control = lmerControl(calc.derivs = FALSE))}}

\item{priorCount}{A 'numeric(1)', which is a prior count to be added to the observations to shrink
the estimated odds ratios of the count component towards zero. Default is 0.1.}

\item{binomialBound}{logical, if ‘TRUE’ then the quasibinomial variance estimator will
be never smaller than 1 (no underdispersion). Default is TRUE.}

\item{i}{\code{character} or \code{integer} to specify the element of the \code{QFeatures} that
contains the log expression intensities that will be modelled.}
}
\value{
SummarizedExperiment or QFeatures instance
}
\description{
Fitting a hurdle msqrob model with an intensity component for
assessing differential abundance and an count component that is
modeling peptide counts using quasibinomial glm for differential
detection of the number of features that were not missing and used
for aggregation
}
\examples{

# Load example data
# The data are a Feature object with containing
# a SummarizedExperiment named "peptide" with MaxQuant peptide intensities
# The data are a subset of spike-in the human-ecoli study
# The variable condition in the colData of the Feature object
# contains information on the spike in condition a-e (from low to high)
data(pe)

# Aggregate peptide intensities to protein expression values
pe <- aggregateFeatures(pe, i = "peptide", fcol = "Proteins", name = "protein")

# Fit Hurdle MSqrob model
# For summarized SummarizedExperiment
se <- pe[["protein"]]
se
colData(se) <- colData(pe)
se <- msqrobHurdle(se, formula = ~condition)
getCoef(rowData(se)$msqrobHurdleIntensity[[1]])
getCoef(rowData(se)$msqrobHurdleCount[[1]])

# For features object
pe <- msqrobHurdle(pe, i = "protein", formula = ~condition)
getCoef(rowData(pe[["protein"]])$msqrobHurdleIntensity[[1]])
getCoef(rowData(pe[["protein"]])$msqrobHurdleCount[[1]])
}
\author{
Lieven Clement
}
