% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusSLP.R
\name{scr_slp}
\alias{scr_slp}
\title{Identify SLPs in screen hits}
\usage{
scr_slp(cell, screen_data, cell_mut, tumour_slp)
}
\arguments{
\item{cell}{a cell line.}

\item{screen_data}{a data.table of genomic screen results with three columns, "screen_entrez", "screen_symbol" and "cell_line".}

\item{cell_mut}{cell line mutation data.}

\item{tumour_slp}{merged SLPs.}
}
\value{
A data.table.
  \describe{
    \item{cell_line}{Name of cell lines.}
    \item{screen_entrez}{Entrez ids of hits.}
    \item{screen_symbol}{Gene symbols of hits.}
    \item{mut_entrez}{Entrez ids of mutations.}
    \item{mut_symbol}{Gene symbols of mutations.}
    \item{is_slp}{Whether the targeted gene is a SLP.}
    \item{pvalue}{p_value from \code{\link[RankProd]{RankProducts}}.}
    \item{fdr}{"BH" adjusted pvalue via \code{\link[stats]{p.adjust}}.}
    \item{im}{The importance value returned by \code{\link{genie3}}.}
    \item{dualhit}{Whether the slp is identified by \code{\link{corr_slp}} and \code{\link{comp_slp}}.}
}
}
\description{
Identify whether screen hits are SLPs of mutations deteced in both patients and cell lines, based on
predicted SLPs in \code{\link{corr_slp}} and \code{\link{comp_slp}}.
}
\examples{
require(future)
require(doFuture)
plan(multisession, workers = 2)
library(magrittr)
library(data.table)
data(example_compSLP)
data(example_corrSLP)
merged_res <- merge_slp(example_compSLP, example_corrSLP)

#- Toy hits data.
screen_1 <- merged_res[, .(slp_entrez, slp_symbol)] \%>\%
    unique \%>\%
    .[sample(nrow(.), round(.8 * nrow(.)))] \%>\%
    setnames(c(1, 2), c("screen_entrez", "screen_symbol")) \%>\%
    .[, cell_line := "cell_1"]

screen_2 <- merged_res[, .(slp_entrez, slp_symbol)] \%>\%
    unique \%>\%
    .[sample(nrow(.), round(.8 * nrow(.)))] \%>\%
    setnames(c(1, 2), c("screen_entrez", "screen_symbol")) \%>\%
    .[, cell_line := "cell_2"]

screen_hit <- rbind(screen_1, screen_2)

#- Toy mutations data.
mut_1 <- merged_res[, .(mut_entrez)] \%>\%
    unique \%>\%
    .[sample(nrow(.), round(.8 * nrow(.)))] \%>\%
    .[, cell_line := "cell_1"]

mut_2 <- merged_res[, .(mut_entrez)] \%>\%
    unique \%>\%
    .[sample(nrow(.), round(.8 * nrow(.)))] \%>\%
    .[, cell_line := "cell_2"]

mut_info <- rbind(mut_1, mut_2)

#- Hits that are identified as SLPs.
scr_res <- lapply(c("cell_1", "cell_2"), scr_slp, screen_hit, mut_info, merged_res)
scr_res[lengths(scr_res) == 0] <- NULL
scr_res <- rbindlist(scr_res)
plan(sequential)
}
