% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral-matching.R
\name{spectral_matching}
\alias{spectral_matching}
\title{Spectral matching \link{deprecated}}
\usage{
spectral_matching(
  query_db_pth,
  ra_thres_l = 0,
  ra_thres_q = 2,
  cores = 1,
  pol = "positive",
  ppm_tol_prod = 10,
  ppm_tol_prec = 5,
  score_thres = 0.6,
  topn = NA,
  db_name = NA,
  library_db_pth = NA,
  instrument_types = NA,
  library_sources = "massbank",
  scan_ids = NA,
  pa = NA,
  xset = NA,
  grp_peaklist = NA,
  out_dir = ".",
  ra_w = 0.5,
  mz_w = 2,
  spectra_type_q = "scans",
  ra_thres_t = NA,
  target_db_pth = NA,
  rt_range = c(NA, NA),
  rttol = NA,
  match_alg = "dpc"
)
}
\arguments{
\item{query_db_pth}{character; Path of the database of targets (queries) that will be searched against the library spectra. Generated
either from frag4feature or from create_database functions.}

\item{ra_thres_l}{numeric; Relative abundance threshold for library spectra}

\item{ra_thres_q}{numeric; Relative abundance threshold for target (query) spectra
(Peaks below this RA threshold will be excluded)}

\item{cores}{numeric; Number of cores to use}

\item{pol}{character; Polarity ['positive' or 'negative']}

\item{ppm_tol_prod}{numeric; PPM tolerance to match to product}

\item{ppm_tol_prec}{numeric; PPM tolerance to match to precursor}

\item{score_thres}{numeric; Dot product cosine score threshold}

\item{topn}{numeric [optional]; Only use top n matches}

\item{db_name}{character [optional]; Name of the result database
(e.g. can use CAMERA peaklist)}

\item{library_db_pth}{character [optional]; path to library spectral SQLite database.
Defaults to msPurityData package data.}

\item{instrument_types}{vector [optional]; Vector of instrument types, defaults to all}

\item{library_sources}{vector [optional]; Vector of library sources. Default option is for massbank only but the 'lipidblast'
library is also available}

\item{scan_ids}{vector [optional]; Vector of unique scan ids calculated from msPurity "pid". These scans will on
used for the spectral matching. All scans will be used if set to NA}

\item{pa}{purityA object [optional]; If target_db_pth set to NA, a new database can be created using pa, xset and grp_peaklist}

\item{xset}{xcms object [optional]; If target_db_pth set to NA, a new database can be created using pa, xset and grp_peaklist}

\item{grp_peaklist}{dataframe [optional]; If target_db_pth set to NA, a new database can be created using pa, xset and grp_peaklist}

\item{out_dir}{character [optional]; If target_db_pth set to NA, Out directory for the SQLite result database}

\item{ra_w}{numeric; Relative abundance weight for spectra}

\item{mz_w}{numeric; mz weight for spectra}

\item{spectra_type_q}{character; Type of fragmentation spectra from query to match with "scans" =  all individual scans,
"av_intra" = averaged spectra (intra), "av_inter" = averaged spectra (inter), "av_all" = averaged all
spectra ignoring inter-intra relationships}

\item{ra_thres_t}{numeric [deprecated]; The relative abundance threshold for the query spectra (use ra_thres_q for future use)}

\item{target_db_pth}{character [deprecated]; The query database path (use query_db_pth for future use)}

\item{rt_range}{vector [optional]; Vector of rention time range to filter the library spectra (rtmin, rtmax). Default is to ignore
retention time range}

\item{rttol}{numeric [optional]; Tolerance in time range between the Library and Query database retention time (in seconds) NA to ignore}

\item{match_alg}{character; Can either use dot product cosine (dpc) or match factor (mf) for spectral matching. Defaults to dpc}
}
\value{
list of database details and dataframe summarising the results for the xcms features
}
\description{
Perform spectral matching to spectral libraries using dot product cosine on a LC-MS/MS dataset and link to XCMS features.

msPurity::spectral_matching is deprecated - please use msPurity::spectralMatching for future use
}
\examples{
#msmsPths <- list.files(system.file("extdata", "lcms", "mzML",
#                         package="msPurityData"), full.names = TRUE,
#                         pattern = "MSMS")
#xset <- xcms::xcmsSet(msmsPths)
#xset <- xcms::group(xset)
#xset <- xcms::retcor(xset)
#xset <- xcms::group(xset)

#pa  <- purityA(msmsPths)
#pa <- frag4feature(pa, xset)
#pa <- averageAllFragSpectra(pa)
#db_pth <- create_database(pa, xset)
#q_dbPth <- system.file("extdata", "tests", "db",
#                        "create_database_example.sqlite", package="msPurity")
#result <- spectral_matching(q_dbPth, spectra_type_q="av_all")
}
