% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-av-spectra.R
\name{averageSpectra,purityD-method}
\alias{averageSpectra,purityD-method}
\alias{averageSpectra}
\title{Using purityD object, calculates to average mz, intensity
and signal-to-noise of multiple scans from multiple MS datafiles
(mzML or .csv)}
\usage{
\S4method{averageSpectra}{purityD}(
  Object,
  rtscn = "all",
  scanRange = NA,
  timeRange = NA,
  clustType = "hc",
  ppm = 1.5,
  snthr = 3,
  av = "median",
  missingV = "zero",
  minfrac = 0.6667,
  normTIC = FALSE,
  snMeth = "median"
)
}
\arguments{
\item{Object}{object; purityD object}

\item{rtscn}{character; Whether it is scans or retention time to be filtered. Use "all" if all scans to be used. ['rt', 'scns', 'all']}

\item{scanRange}{vector; Scan range (if rtscn='scns') e.g. c(40, 69)}

\item{timeRange}{vector; Time range (if rtscn='rt) e.g. c(10.3, 400.8) (only if using mzML file)}

\item{clustType}{character; Type of clustering used either Hierarchical or just simple 1D grouping ['hc', 'simple']}

\item{ppm}{numeric; The ppm error to cluster mz together}

\item{snthr}{numeric; Signal to noise ratio threshold}

\item{av}{character; What type of averaging to do between peaks}

\item{missingV}{character; What to do with missing values (zero or ignore)}

\item{minfrac}{numeric; Min fraction of scans with a grouped peak to be an accepted averaged peak}

\item{normTIC}{boolean; If TRUE then RSD calculation will use the normalised intensity (intensity divided by TIC) if FALSE will use standard intensity}

\item{snMeth}{character; Type of snMethod to use ['mean', 'median', 'precalc']. Precalc only applicable when using the csvFile parameter as TRUE}
}
\value{
purityD object with averaged spectra
}
\description{
Uses a purityD object with references to multiple MS files. For each file:
Averages multiple scans together,
see averageSpectraSingle for more information
}
\examples{

datapth <- system.file("extdata", "dims", "mzML", package="msPurityData")
inDF <- Getfiles(datapth, pattern=".mzML", check = FALSE, cStrt = FALSE)
ppDIMS <- purityD(fileList=inDF, cores=1, mzML=TRUE)
ppDIMS <- averageSpectra(ppDIMS)
}
\seealso{
\code{\link{averageSpectraSingle}}
}
