% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityA-av-spectra.R
\name{averageAllFragSpectra,purityA-method}
\alias{averageAllFragSpectra,purityA-method}
\alias{averageAllFragSpectra}
\title{Using a purityA object, average and filter MS/MS spectra for each XCMS feature within
and across MS data files (ignoring intra and inter relationships)}
\usage{
\S4method{averageAllFragSpectra}{purityA}(
  pa,
  minfrac = 0.5,
  minnum = 1,
  ppm = 5,
  snr = 0,
  ra = 0,
  av = "median",
  sumi = TRUE,
  rmp = FALSE,
  cores = 1
)
}
\arguments{
\item{pa}{object; purityA object}

\item{minfrac}{numeric;minimum ratio of the peak fraction (peak count / total peaks) across all (ignoring intra and inter relationships)}

\item{minnum}{numeric; minimum number of times peak is present across all fragmentation spectra (ignoring intra and inter relationships)}

\item{ppm}{numeric; ppm threshold to average across all scans (ignoring intra and inter relationships)}

\item{snr}{numeric;  minimum signal-to-noise of the peak across all (ignoring intra and inter relationships)}

\item{ra}{numeric; minimum relative abundance of the peak fraction across all (ignoring intra and inter relationships)}

\item{av}{character; type of averaging to use (median or mean)}

\item{sumi}{boolean; TRUE if the intensity for each peak is summed across averaged spectra}

\item{rmp}{boolean; TRUE if peaks are to be removed that do not meet the threshold criteria. Otherwise they will just be flagged}

\item{cores}{numeric; Number of cores for multiprocessing}
}
\value{
Returns a purityA object (pa) with the following slots now with data
\itemize{
\item pa@av_spectra: the average spectra is recorded here stored as a list. E.g. pa@av_spectra$\code{1}$av_all would give the average spectra for grouped feature 1.
\item pa@av_all_params: The parameters used are recorded here
}

Each spectra in the av_spectra list contains the following columns:
\itemize{
\item cl: id of clustered (averaged) peak
\item mz: average m/z
\item i: average intensity
\item snr: average signal to noise ratio
\item rsd: relative standard deviation
\item count: number of clustered peaks
\item total: total number of potential scans to be used for averaging
\item inPurity: average precursor ion purity
\item ra: average relative abundance
\item frac: the fraction of clustered peaks (e.g. the count/total)
\item snr_pass_flag: TRUE if snr threshold criteria met
\item minfrac_pass_flag: TRUE if minfrac threshold criteria
\item ra_pass_flag: TRUE if ra threshold criteria met
\item pass_flag: TRUE if all threshold criteria met
}
}
\description{
\strong{General}

Average and filter fragmentation spectra for each XCMS feature within and across MS data files (ignoring intra and inter relationships).

The averaging is performed using hierarchical clustering of the m/z values of each peaks, where m/z values within a set ppm tolerance will be clustered. The clustered peaks are then averaged (or summed).

The fragmentation can be filtered on the averaged spectra (with the arguments snr, rsd, minfrac, ra)

\strong{Example LC-MS/MS processing workflow}
\itemize{
\item Purity assessments
\itemize{
\item (mzML files) -> purityA -> (pa)
}
\item XCMS processing
\itemize{
\item (mzML files) -> xcms.findChromPeaks -> (optionally) xcms.adjustRtime -> xcms.groupChromPeaks -> (xcmsObj)
\item --- \emph{Older versions of XCMS} --- (mzML files) -> xcms.xcmsSet -> xcms.group -> xcms.retcor -> xcms.group -> (xcmsObj)
}
\item Fragmentation processing
\itemize{
\item (xcmsObj, pa) -> frag4feature -> filterFragSpectra -> \strong{averageAllFragSpectra} -> createDatabase -> spectralMatching -> (sqlite spectral database)
}
}
}
\examples{

#====== XCMS ===================================
## Read in MS data
#msmsPths <- list.files(system.file("extdata", "lcms", "mzML",
#           package="msPurityData"), full.names = TRUE, pattern = "MSMS")
#ms_data = readMSData(msmsPths, mode = 'onDisk', msLevel. = 1)

## Find peaks in each file
#cwp <- CentWaveParam(snthresh = 5, noise = 100, ppm = 10, peakwidth = c(3, 30))
#xcmsObj  <- xcms::findChromPeaks(ms_data, param = cwp)

## Optionally adjust retention time
#xcmsObj  <- adjustRtime(xcmsObj , param = ObiwarpParam(binSize = 0.6))

## Group features across samples
#pdp <- PeakDensityParam(sampleGroups = c(1, 1), minFraction = 0, bw = 30)
#xcmsObj <- groupChromPeaks(xcmsObj , param = pdp)

#====== msPurity ================================
#pa  <- purityA(msmsPths)
#pa <- frag4feature(pa, xcmsObj)
#pa <- filterFragSpectra(pa)
#pa <- averageAllFragSpectra(pa)

## Run from previously generated data
pa <- readRDS(system.file("extdata", "tests", "purityA",
                          "3_filterFragSpectra_pa.rds", package="msPurity"))
pa <- averageAllFragSpectra(pa)


}
