% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCV2.R
\name{plotCV2}
\alias{plotCV2}
\title{Plot mean-CV^2 trend}
\usage{
plotCV2(y, trend = TRUE, main = NULL, ...)
}
\arguments{
\item{y}{numeric matrix of log-intensity}

\item{trend}{logical. Should a loess trend be fitted to CV^2 and mean values. Default to TRUE.}

\item{main}{character string. Title of the plot. Default  to NULL.}

\item{...}{any parameter passed to \code{plot}.}
}
\value{
A plot is created on the current graphics device.
}
\description{
For each peptide, the squares of coefficient of variations are computed and plotted against average log-intensity.
Additionally, a loess trend is fitted to the plotted values.
Outlier observations (possibly originated from incorrect match between runs), are detected and highlighted.
Users can use this plot as a diagnostic plot to determine if filtering by average intensity is required.
}
\details{
Outliers are determined by computing the RBF kernels, which reflect the chance that an observed point
belong to the dataset (i.e. is close enough in distance to other data points). Users can determine the cut-off
for intensity-based filtering with respect to the mean log-intensity of the outlier points.
}
\examples{
data(pxd010943)
y <- pxd010943
y <- log2(y)
ppCV2 <- plotCV2(y)

}
