% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_wrapper.R
\name{simulateNumHitsDist}
\alias{simulateNumHitsDist}
\title{Empirical number of motif hits distribution}
\usage{
simulateNumHitsDist(pfm, bg, seqlen, nsim, singlestranded = FALSE)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}

\item{seqlen}{Integer-valued vector that defines the lengths of the
individual sequences. For a given DNAStringSet, 
this information can be retrieved using \code{\link{numMotifHits}}.}

\item{nsim}{Integer number of random samples.}

\item{singlestranded}{Boolean that indicates whether a single strand or
both strands shall be scanned for motif hits.
Default: singlestranded = FALSE.}
}
\value{
A List that contains
\describe{
\item{dist}{Empirical distribution of the number of motif hits}
}
}
\description{
This function repeatedly simulates random DNA sequences according to
the background model and
subsequently counts how many motif hits occur in them.
Thus, this function gives rise to the empirical
distribution of the number of motif hits.
This function is only used for benchmarking analysis.
}
\examples{


# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Study the counts in one sequence of length 150 bp
seqlen = rep(150, 1)

# Compute empirical distribution of the number of motif hits
# by scanning both strands using 100 samples
simc = motifcounter:::simulateNumHitsDist(motif, bg,
    seqlen, nsim = 100, singlestranded = FALSE)

# Compute empirical distribution of the number of motif hits
# by scanning a single strand using 100 samples
simc = motifcounter:::simulateNumHitsDist(motif, bg,
    seqlen, nsim = 100, singlestranded = TRUE)

}
\seealso{
\code{\link{compoundPoissonDist}},\code{\link{combinatorialDist}}
}
