% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_wrapper.R
\name{generateDNAStringSet}
\alias{generateDNAStringSet}
\title{Generate DNAStringSet}
\usage{
generateDNAStringSet(seqlen, bg)
}
\arguments{
\item{seqlen}{Integer-valued vector that defines the lengths of the
individual sequences. For a given DNAStringSet, 
this information can be retrieved using \code{\link{numMotifHits}}.}

\item{bg}{A Background object}
}
\value{
A DNAStringSet object
}
\description{
This function generates a DNAStringSet-object of the
given individual sequence lengths
by sampling from the background model.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Generate random sequences of various lengths
motifcounter:::generateDNAStringSet(10:50, bg)

}
\seealso{
\code{\link{generateDNAStringSet}}
}
