% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locus.from.rsid.R
\name{snps.from.rsid}
\alias{snps.from.rsid}
\title{Import SNPs from rsid for use in motifbreakR}
\usage{
snps.from.rsid(
  rsid = NULL,
  dbSNP = NULL,
  search.genome = NULL,
  biomart.dataset = NULL
)
}
\arguments{
\item{rsid}{Character; a character vector of rsid values from dbSNP}

\item{dbSNP}{an object of class SNPlocs to lookup rsids; see \code{availible.SNPs} in
\code{\link[BSgenome]{injectSNPs}} to check for availible SNPlocs}

\item{search.genome}{an object of class BSgenome for the species you are interrogating;
see \code{\link[BSgenome]{available.genomes}} for a list of species.}

\item{biomart.dataset}{a Mart object from \code{\link{useEnsembl}} specifying
the \code{snps} biomart, which dataset i.e., \code{hsapiens_snp}, and which
version i.e., \code{111} or \code{GRCm39}. This will override \code{SNPlocs} and must
be compatible with search.genome selection, and will query from \code{biomaRt},
which may be considerably faster than a lookup from a \code{SNPlocs} object.}
}
\value{
a GRanges object containing:
 \item{SNP_id}{The rsid of the snp with the "rs" portion stripped}
 \item{alleles_as_ambig}{THE IUPAC ambiguity code between the reference and
 alternate allele for this SNP}
 \item{REF}{The reference allele for the SNP}
 \item{ALT}{The alternate allele for the SNP}
}
\description{
Import SNPs from rsid for use in motifbreakR
}
\details{
\code{snps.from.rsid} take an rsid, or character vector of rsids and
 generates the required object to input into \code{motifbreakR}
}
\examples{
 library(BSgenome.Hsapiens.UCSC.hg19)
 library(SNPlocs.Hsapiens.dbSNP155.GRCh37)
 snps.file <- system.file("extdata", "pca.enhancer.snps", package = "motifbreakR")
 snps <- as.character(read.table(snps.file)[,1])
 snps.mb <- snps.from.rsid(snps[1],
                           dbSNP = SNPlocs.Hsapiens.dbSNP155.GRCh37,
                           search.genome = BSgenome.Hsapiens.UCSC.hg19)

 ## alternatively using biomaRt

 library(biomaRt)
 library(BSgenome.Hsapiens.UCSC.hg38)
 ensembl_snp <- useEnsembl(biomart = "snps",
                           dataset = "hsapiens_snp",
                           version = "112")
 snps.mb <- snps.from.rsid(snps,
                           biomart.dataset = ensembl_snp,
                           search.genome = BSgenome.Hsapiens.UCSC.hg38)

}
\seealso{
See \code{\link{motifbreakR}} for analysis; See \code{\link{snps.from.file}}
  for an alternate method for generating a list of variants.
}
