% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreMotif.R
\name{findSupportingRemapPeaks}
\alias{findSupportingRemapPeaks}
\title{Find Corresponding TF Binding From The ReMap2022 Project}
\usage{
findSupportingRemapPeaks(results, genome, TFClass = FALSE)
}
\arguments{
\item{results}{The output of \code{motifbreakR}}

\item{genome}{Character; one of:
\code{hg38} or \code{hg19} for Homo sapiens,
\code{mm10} or \code{mm39} for Mus musculus,
\code{dm6} for Drosophila melanogaster,
\code{TAIR10_TF} or \code{TAIR10_HISTONE} for Arabidopsis thaliana}

\item{TFClass}{Logical;  The user may optionally query an expanded
motif/transcription factor relationship encompassing the entire potential
transcription factor family as implemented by \code{\link{MotifDb}} based on
TFClass.}
}
\value{
the results GenomicRanges object output by \code{\link{motifbreakR}}
containing with the additional columns:
 \item{matchingBindingEvent}{The name of the transcription factor that binds
 over the motif, or \code{NA} if none}
 \item{matchingCellType}{A list corresponding in length to the number of
 transcription factors in \code{matchingBindingEvent} indicating the
 biotype/celltype that the transcription factor binding was found in.}
}
\description{
Find Corresponding TF Binding From The ReMap2022 Project
}
\details{
\code{TFClass} argument works for objects loaded in from the
\code{MotifDb} package. \code{hg19} and \code{mm39} are data from liftOver.

The ReMap catalogues (2022, 2020, 2018, 2015) are under CC BY-NC 4.0
international license, as described in ReMap.

The CC BY-NC 4.0 license correspond to the following terms:
Attribution — You must give appropriate credit, provide a link to the
license, and indicate if changes were made. You may do so in any reasonable
manner, but not in any way that suggests the licensor endorses you or your
use.
NonCommercial — You may not use the material for commercial purposes.
No additional restrictions — You may not apply legal terms or technological
measures that legally restrict others from doing anything the license
permits.
}
\examples{
data(example.results)
\donttest{
example.results <- findSupportingRemapPeaks(example.results,
                                            genome = "hg19",
                                            TFClass = TRUE)
}
}
\seealso{
\code{\link{associateTranscriptionFactors}} for information about
TFClass. \url{https://remap.univ-amu.fr/} for details about ReMap2022.
}
