% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{replace_values_float}
\alias{replace_values_float}
\title{Replace values in a adjacency matrix.}
\usage{
replace_values_float(mat, threshold, replace_higher = TRUE)
}
\arguments{
\item{mat}{A numeric matrix}

\item{threshold}{All values in the matrix lower than this values are 
replaced by 0.}

\item{replace_higher}{If set to true, all values >= \code{threshold} 
are replaced by 1.}
}
\value{
A numeric matrix with (partially) replaced values.
}
\description{
Same as \code{\link{replace_values}}, but for (positive) non-integer
matrices.
}
\details{
Replace values in a numeric matrix, that are lower than a certain 
threshold.
}
\examples{
replace_values(matrix(rnorm(100), nrow=10), threshold=1)

}
