% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{filter_bicluster_size}
\alias{filter_bicluster_size}
\title{Filter a list of bicluster objects, by erasing all biclusters, 
that do not fulfill the minimum number of rows and columns.
Utilizes the function \code{\link{validate_bicluster}}.}
\usage{
filter_bicluster_size(bics, minRow, minCol)
}
\arguments{
\item{bics}{List of bicluster objects.}

\item{minRow}{Minimum number of rows.}

\item{minCol}{Minimum number of columns.}
}
\value{
A filtered list of bicluster objects.
}
\description{
Filter a list of bicluster objects, by erasing all biclusters, 
that do not fulfill the minimum number of rows and columns.
Utilizes the function \code{\link{validate_bicluster}}.
}
\examples{
b <- list(bicluster(row=c(1,2), column=c(1,2,3,4)),
        bicluster(row=c(3,4,5,6), column=c(3,4,5,6)))
filter_bicluster_size(b, 3, 3)

}
