% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Heatmap of log-transformed normalization data}
\usage{
plotHeatmap(
  data,
  value = "RPM",
  pseudocount = 1e-06,
  colours = (grDevices::colorRampPalette(RColorBrewer::brewer.pal(9, "GnBu")))(100),
  cluster = TRUE,
  scale = "none",
  clustering_method = "complete",
  row.names = FALSE,
  border.color = NA,
  column.angle = 45,
  title = NA
)
}
\arguments{
\item{data}{data.frame; originally generated by \code{\link[=RNAimport]{RNAimport()}}}

\item{value}{character; state the values to plot, either \code{FPKM} or \code{RPM}.}

\item{pseudocount}{numeric; pseudo count, default is \code{1e-6}}

\item{colours}{character; colors. Default is
\code{grDevices::colorRampPalette(RColorBrewer::brewer.pal(9, "GnBu"))(100)}}

\item{cluster}{logical; include hierarchical clustering when default
\code{cluster= TRUE}}

\item{scale}{character; indicating whether the values should be centered &
scaled in either the row direction or the column direction, or none.
Respective options are "row", "column" & "none". Default is \code{scale="none"}.}

\item{clustering_method}{character; clustering method used. Accepts the same
values as hclust. Default \code{clustering_method= "complete"}}

\item{row.names}{logical; indicated whether to include rownames from column
1 of data frame. Default \code{row.names=FALSE}}

\item{border.color}{character; the border colour. Default is no border (NA).}

\item{column.angle}{numeric; angle of the column labels, choose from 0, 45,
90, 270 or 315.}

\item{title}{character; states plot title, placed at the top center}
}
\value{
Produces a list objects storing the heatmap plot and the data.
}
\description{
Undertakes normalisation of RPM/FPKM using a pseudocount and
transforms the data using log-scale, to enable visualization of the
differences and patterns in expression across samples using a heatmap.
}
\details{
Undertakes FPKM/RPM normalisation using a pseudocount and then
transforms the normalised-RPM data using log-scale.

This function expects to receive a data frame containing FPKM/RPM data.
This function employs the use of a pseudo count during
normalisation as the function is expected to be used when identifying mobile
sRNAs in a chimeric system. In such system, it is expected that control
replicates will contain zero values for the candidate mobile sRNA clusters.
}
\examples{
data("sRNA_data")

# vector of control names
controls <- c("selfgraft_1", "selfgraft_2" , "selfgraft_3")

# Locate potentially mobile sRNA clusters associated to tomato, no
# statistical analysis
sRNA_data_mobile <- RNAmobile(input = "sRNA", data =  sRNA_data,
controls = controls, genome.ID = "B_", task = "keep", statistical = FALSE)

# plot heatmap of potential mobile sRNAs
 p1 <-  plotHeatmap(sRNA_data_mobile)




}
