% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllHelper.R
\name{Moanin-methods}
\alias{Moanin-methods}
\alias{group_variable_name}
\alias{group_variable_name,Moanin-method}
\alias{group_variable_name<-,Moanin-method}
\alias{group_variable_name<-}
\alias{time_by_group_variable,Moanin-method}
\alias{time_by_group_variable}
\alias{group_variable,Moanin-method}
\alias{group_variable}
\alias{group_variable<-,Moanin-method}
\alias{group_variable<-}
\alias{time_variable_name,Moanin-method}
\alias{time_variable_name}
\alias{time_variable_name<-,Moanin-method}
\alias{time_variable_name<-}
\alias{time_variable,Moanin-method}
\alias{time_variable}
\alias{time_variable<-,Moanin-method}
\alias{time_variable<-}
\alias{degrees_of_freedom,Moanin-method}
\alias{degrees_of_freedom}
\alias{basis_matrix,Moanin-method}
\alias{basis_matrix}
\alias{spline_formula,Moanin-method}
\alias{spline_formula}
\alias{show,Moanin-method}
\alias{show}
\alias{[,Moanin,ANY,character,ANY-method}
\alias{[,Moanin,ANY,ANY,ANY-method}
\alias{[,Moanin,ANY,logical,ANY-method}
\alias{[,Moanin,ANY,numeric,ANY-method}
\alias{log_transform,Moanin-method}
\alias{log_transform}
\alias{get_log_data,Moanin-method}
\alias{get_log_data}
\title{Helper methods for the Moanin class}
\usage{
\S4method{group_variable_name}{Moanin}(object)

\S4method{group_variable_name}{Moanin}(object) <- value

\S4method{time_by_group_variable}{Moanin}(object)

\S4method{group_variable}{Moanin}(object)

\S4method{group_variable}{Moanin}(object) <- value

\S4method{time_variable_name}{Moanin}(object)

\S4method{time_variable_name}{Moanin}(object) <- value

\S4method{time_variable}{Moanin}(object)

\S4method{time_variable}{Moanin}(object) <- value

\S4method{degrees_of_freedom}{Moanin}(object)

\S4method{basis_matrix}{Moanin}(object)

\S4method{spline_formula}{Moanin}(object)

\S4method{show}{Moanin}(object)

\S4method{[}{Moanin,ANY,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Moanin,ANY,logical,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{Moanin,ANY,numeric,ANY}(x, i, j, ..., drop = TRUE)

\S4method{log_transform}{Moanin}(object)

\S4method{get_log_data}{Moanin}(object)
}
\arguments{
\item{object}{An object of class \code{\link{Moanin}}, an object containing
all related information for time course data and the splines model that
will be used (if applicable). See \code{\link{create_moanin_model}} for
more details.}

\item{value}{replacement value}

\item{x}{\code{Moanin} object}

\item{i, j}{A vector of logical or integer subscripts, indicating the rows and
columns to be subsetted for \code{i} and \code{j}, respectively.}

\item{...}{arguments passed to subsetting}

\item{drop}{A logical scalar that is ignored.}
}
\value{
\code{group_variable_name} and \code{time_variable_name} return the 
name of the column containing the variable. \code{group_variable} and 
\code{time_variable} return the  actual variable.
}
\description{
This is a collection of helper methods for the Moanin
  class.
}
\details{
Note that when subsetting the data, the dendrogram information and
  the co-clustering matrix are lost.
}
\examples{
# Load some data
data(exampleData)
moanin = create_moanin_model(data=testData,meta=testMeta)
group_variable_name(moanin)
time_variable_name(moanin)
}
