% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods-plot.tune.R
\name{plot.tune}
\alias{plot.tune}
\alias{plot.tune.spls}
\alias{plot.tune.block.splsda}
\alias{plot.tune.spca}
\alias{plot.tune.spls1}
\alias{plot.tune.splsda}
\title{Plot model performance}
\usage{
\method{plot}{tune.spls}(
  x,
  measure = NULL,
  comp = c(1, 2),
  pch = 16,
  cex = 1.2,
  title = NULL,
  size.range = c(3, 10),
  sd = NULL,
  ...
)

\method{plot}{tune.block.splsda}(x, sd = NULL, col, ...)

\method{plot}{tune.spca}(x, optimal = TRUE, sd = NULL, col = NULL, ...)

\method{plot}{tune.spls1}(x, optimal = TRUE, sd = NULL, col, ...)

\method{plot}{tune.splsda}(x, optimal = TRUE, sd = NULL, col, ...)
}
\arguments{
\item{x}{an \code{tune.splsda} object.}

\item{measure}{Character. Measure used for plotting a \code{tune.spls} object.
One of c('cor', 'RSS').}

\item{comp}{Integer of length 2 denoting the components to plot.}

\item{pch}{value or vector, controls shape of points to be plotted. Can be used 
to control the shape of the points directly or to create a second group membership
and legend. See details.}

\item{cex}{numeric character (or symbol) expansion, possibly vector.}

\item{title}{Plot title.}

\item{size.range}{Numeric vector of length 2. Range of sizes used in plot.}

\item{sd}{If 'nrepeat' was used in the call to 'tune.splsda', error bar
shows the standard deviation if sd=TRUE}

\item{...}{Not currently used.}

\item{col}{character (or symbol) color to be used, possibly vector. One
colour per component.}

\item{optimal}{If TRUE, highlights the optimal keepX per component}
}
\value{
none

none
}
\description{
Function to plot performance criteria, such as classification error rate or
correlation of cross-validated components for different models.

Function to plot performance criteria, such as classification error rate or
balanced error rate on a tune.splsda result.
}
\details{
\code{plot.tune.splsda} plots the classification error rate or the balanced
error rate from x$error.rate, for each component of the model. A lozenge
highlights the optimal number of variables on each component.

\code{plot.tune.block.splsda} plots the classification error rate or the
balanced error rate from x$error.rate, for each component of the model. The
error rate is ordered by increasing value, the yaxis shows the optimal
combination of keepX at the top (e.g. `keepX on block 1'_`keepX on block
2'_`keepX on block 3')

\code{plot.tune.spls} plots either the correlation of cross-validated
components or the Residual Sum of Square (RSS) values for these components
against those from the full model for both \code{t} (X components) and
\code{u} (Y components). The optimal number of features chosen are indicated
by squares.

If neither of the \code{object$test.keepX} or \code{object$test.keepY} are
fixed, a dot plot is produced where a larger size indicates the strength of
the measure (higher correlation or lower RSS). Otherwise, the measures are
plotted against the number of features selected. In both cases, the colour
shows the dispersion of the values across repeated cross validations.

\code{plot.tune.spca} plots the correlation of cross-validated components from
the \code{tune.spca} function with respect to the full model.

\code{plot.tune.splsda} plots the classification error rate or the balanced
error rate from x$error.rate, for each component of the model. A lozenge
highlights the optimal number of variables on each component.

\code{plot.tune.block.splsda} plots the classification error rate or the
balanced error rate from x$error.rate, for each component of the model. The
error rate is ordered by increasing value, the yaxis shows the optimal
combination of keepX at the top (e.g. `keepX on block 1'_`keepX on block
2'_`keepX on block 3')
}
\section{plot arguments for pls2 tuning}{

For tune.spls objects where tuning is performed on both X and Y, arguments
'col.low.sd' and 'col.high.sd' can be used to indicate a low and high sd, 
respectively. Default to 'blue' & 'red'.
}

\examples{

\dontrun{
## validation for objects of class 'splsda'

data(breast.tumors)
X = breast.tumors$gene.exp
Y = as.factor(breast.tumors$sample$treatment)
out = tune.splsda(X, Y, ncomp = 3, nrepeat = 5, logratio = "none",
test.keepX = c(5, 10, 15), folds = 10, dist = "max.dist",
progressBar = TRUE)


plot(out, sd=TRUE)
}
\dontrun{
## validation for objects of class 'mint.splsda'

data(stemcells)
data = stemcells$gene
type.id = stemcells$celltype
exp = stemcells$study

out = tune(method="mint.splsda", X=data,Y=type.id, ncomp=2, study=exp, test.keepX=seq(1,10,1))
out$choice.keepX

plot(out)

## validation for objects of class 'mint.splsda'

data("breast.TCGA")
# this is the X data as a list of mRNA and miRNA; the Y data set is a single data set of proteins
data = with(breast.TCGA$data.train, list(mrna = mrna, 
            mirna = mirna,
            protein = protein,
            Y = subtype))
# set number of component per data set
ncomp = 5

# Tuning the first two components
# -------------

# definition of the keepX value to be tested for each block mRNA miRNA and protein
# names of test.keepX must match the names of 'data'
test.keepX = list(mrna = seq(10,40,20), mirna = seq(10,30,10), protein = seq(1,10,5))

# the following may take some time to run, note that for through tuning
# nrepeat should be > 1
tune = tune.block.splsda(X = data, indY = 4,
ncomp = ncomp, test.keepX = test.keepX, design = 'full', nrepeat = 3)

tune$choice.ncomp
tune$choice.keepX

plot(tune)
## --- spls model
data(nutrimouse)
X <- nutrimouse$gene  
Y <- nutrimouse$lipid
list.keepX <- c(2:10, 15, 20)
# tuning based on correlations
set.seed(30)
## tune X only
tune.spls.cor.X <- tune.spls(X, Y, ncomp = 3,
                           test.keepX = list.keepX,
                           validation = "Mfold", folds = 5,
                           nrepeat = 3, progressBar = FALSE,
                           measure = 'cor')

plot(tune.spls.cor.X)
plot(tune.spls.cor.X, measure = 'RSS')

## tune Y only
tune.spls.cor.Y <- tune.spls(X, Y, ncomp = 3,
                           test.keepY = list.keepX,
                           validation = "Mfold", folds = 5,
                           nrepeat = 3, progressBar = FALSE,
                           measure = 'cor')

plot(tune.spls.cor.Y)
plot(tune.spls.cor.Y, sd = FALSE)
plot(tune.spls.cor.Y, measure = 'RSS')

## tune Y and X
tune.spls.cor.XY <- tune.spls(X, Y, ncomp = 3,
                             test.keepY = c(8, 15, 20),
                             test.keepX = c(8, 15, 20),
                             validation = "Mfold", folds = 5,
                             nrepeat = 3, progressBar = FALSE,
                             measure = 'cor')

plot(tune.spls.cor.XY)
## show RSS
plot(tune.spls.cor.XY, measure = 'RSS')
## customise point sizes
plot(tune.spls.cor.XY, size.range = c(6,12))
}
}
\seealso{
\code{\link{tune.mint.splsda}}, \code{\link{tune.splsda}},
  \code{\link{tune.block.splsda}}, \code{\link{tune.spca}} and
  http://www.mixOmics.org for more details.

\code{\link{tune.mint.splsda}}, \code{\link{tune.splsda}}
\code{\link{tune.block.splsda}} and http://www.mixOmics.org for more
details.
}
\author{
Kim-Anh Lê Cao, Florian Rohart, Francois Bartolo, Al J Abadi

Kim-Anh Lê Cao, Florian Rohart, Francois Bartolo, AL J Abadi
}
\keyword{hplot}
\keyword{multivariate}
\keyword{regression}
