% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{setVarsCandidate}
\alias{setVarsCandidate}
\title{mutationCalls cluster setter}
\usage{
setVarsCandidate(mutcall, varlist)
}
\arguments{
\item{mutcall}{object of class \code{\link{mutationCalls}}.}

\item{varlist}{vector of booleans with the names set to the variants
to use for clustering}
}
\value{
Sets the cluster slot on a mutationCalls object
}
\description{
Sets the putative variants that we want to use for clustering
}
\examples{
load(system.file("extdata/LudwigFig7.Rda",package =
"mitoClone2"))
mutations_to_cluster <- getVarsCandidate(LudwigFig7)
mutations_to_cluster[] <- rep(c(TRUE,FALSE),each=19)
LudwigFig7 <- setVarsCandidate(LudwigFig7,mutations_to_cluster)
}
