% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_dis.R
\name{com_dis,matrix,ANY-method}
\alias{com_dis,matrix,ANY-method}
\alias{com_dis,matrix,character-method}
\title{Calculate the community dissimilarity / distance matrix of the input matrix.}
\usage{
\S4method{com_dis}{matrix,ANY}(x, method = "bray", threads = 80, nblocks = 400, ...)

\S4method{com_dis}{matrix,character}(x, method = "bray", threads = 80, nblocks = 400, ...)
}
\arguments{
\item{x}{A matrix of the quantitative table.}

\item{method}{The dissimilarity / distance method used, default `bray`.}

\item{threads}{(optional, only needed when method == "tina") The number of
threads used for parallel running.}

\item{nblocks}{(optional, only needed when method == "tina") The number of
row / column for splitted sub-matrix.}

\item{...}{Additional parameters.}
}
\value{
y The dissimilarity / distance matrix.
}
\description{
Calculate the community dissimilarity / distance matrix of the input matrix.
}
\examples{
asv_norm <- norm_tab(maize_asv2, method = "raref", depth = 1000)
asv_dis <- com_dis(asv_norm, method = "bray")
}
