% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNhoods.R
\name{plotNhoodExpressionDA}
\alias{plotNhoodExpressionDA}
\alias{plotNhoodExpressionGroups}
\title{Visualize gene expression in neighbourhoods}
\usage{
plotNhoodExpressionDA(
  x,
  da.res,
  features,
  alpha = 0.1,
  subset.nhoods = NULL,
  cluster_features = FALSE,
  assay = "logcounts",
  scale_to_1 = FALSE,
  show_rownames = TRUE,
  highlight_features = NULL
)

plotNhoodExpressionGroups(
  x,
  da.res,
  features,
  alpha = 0.1,
  subset.nhoods = NULL,
  cluster_features = FALSE,
  assay = "logcounts",
  scale_to_1 = FALSE,
  show_rownames = TRUE,
  highlight_features = NULL,
  grid.space = "free"
)
}
\arguments{
\item{x}{A \code{\linkS4class{Milo}} object}

\item{da.res}{a data.frame of DA testing results}

\item{features}{a character vector of features to plot (they must be in rownames(x))}

\item{alpha}{significance level for Spatial FDR (default: 0.1)}

\item{subset.nhoods}{A logical, integer or character vector indicating a subset of nhoods to show in plot
(default: NULL, no subsetting)}

\item{cluster_features}{logical indicating whether features should be clustered with hierarchical clustering.
If FALSE then the order in \code{features} is maintained (default: FALSE)}

\item{assay}{A character scalar that describes the assay slot to use for calculating neighbourhood expression.
(default: logcounts)
Of note: neighbourhood expression will be computed only if the requested features are not in the \code{nhoodExpression} slot
of the milo object. If you wish to plot average neighbourhood expression from a different assay, you should run
\code{calcNhoodExpression(x)} with the desired assay.}

\item{scale_to_1}{A logical scalar to re-scale gene expression values between 0 and 1 for visualisation.}

\item{show_rownames}{A logical scalar whether to plot rownames or not. Generally useful to set this to
\code{show_rownames=FALSE} when plotting many genes.}

\item{highlight_features}{A character vector of feature names that should be highlighted on the right side of
the heatmap. Generally useful in conjunction to \code{show_rownames=FALSE}, if you are interested in only a few
features}

\item{grid.space}{a character setting the \code{space} parameter for \code{facet.grid} (\code{'fixed'} for equally sized facets,
\code{'free'} to adapt the size of facent to number of neighbourhoods in group)}
}
\value{
a \code{ggplot} object

a \code{ggplot} object
}
\description{
Plots the average gene expression in neighbourhoods, sorted by DA fold-change

Plots the average gene expression in neighbourhood groups
}
\examples{
NULL

NULL

}
\author{
Emma Dann
}
