% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{Milo-methods}
\alias{Milo-methods}
\alias{graph}
\alias{graph<-}
\alias{graph,Milo-method}
\alias{graph<-,Milo-method}
\alias{nhoodDistances}
\alias{nhoodDistances<-}
\alias{nhoodDistances,Milo-method}
\alias{nhoodDistances<-,Milo-method}
\alias{nhoodCounts}
\alias{nhoodCounts<-}
\alias{nhoodCounts,Milo-method}
\alias{nhoodCounts<-,Milo-method}
\alias{nhoodExpression}
\alias{nhoodExpression<-}
\alias{nhoodExpression,Milo-method}
\alias{nhoodExpression<-,Milo-method}
\alias{nhoodIndex}
\alias{nhoodIndex<-}
\alias{nhoodIndex,Milo-method}
\alias{nhoodIndex<-,Milo-method}
\alias{nhoodReducedDim}
\alias{nhoodReducedDim<-}
\alias{nhoodReducedDim,Milo-method}
\alias{nhoodReducedDim<-,Milo-method}
\alias{nhoods}
\alias{nhoods<-}
\alias{nhoods,Milo-method}
\alias{nhoods<-,Milo-method}
\alias{nhoodGraph}
\alias{nhoodGraph<-}
\alias{nhoodGraph,Milo-method}
\alias{nhoodGraph<-,Milo-method}
\alias{nhoodAdjacency}
\alias{nhoodAdjacency<-}
\alias{nhoodAdjacency,Milo-method}
\alias{nhoodAdjacency<-,Milo-method}
\alias{show}
\alias{show,Milo-method}
\title{Get and set methods for Milo objects}
\value{
See individual methods for return values
}
\description{
Get and set methods for Milo object slots. Generally speaking these methods
are used internally, but they allow the user to assign their own externally computed
values - should be used \emph{with caution}.
}
\section{Getters}{

In the following descriptions \code{x} is always a \linkS4class{Milo} object.
\describe{
\item{\code{graph(x)}:}{Returns an \code{igraph} object representation of the
KNN-graph, with number of vertices equal to the number of single-cells.}
\item{\code{nhoodDistances(x)}:}{Returns a list of sparse matrix of cell-to-cell distances
between nearest neighbours, one list entry per neighbourhood. Largely used internally for computing the k-distance
weighting in \code{graphSpatialFDR}.}
\item{\code{nhoodCounts(x)}:}{Returns a NxM sparse matrix of cell counts in
each of \code{N} neighbourhoods with respect to the \code{M} experimental samples defined.}
\item{\code{nhoodExpression(x)}:}{Returns a GxN matrix of gene expression values.}
\item{\code{nhoodIndex(x)}:}{Returns a list of the single-cells that are the
neighbourhood indices.}
\item{\code{nhoodReducedDim(x)}:}{Returns an NxP matrix of reduced dimension positions. Either
generated by \code{projectNhoodExpression(x)} or by providing an NxP matrix (see
setter method below).}
\item{\code{nhoods(x)}:}{Returns a sparse matrix of \code{CxN} mapping of \code{C} single-cells to\code{N} neighbourhoods.}
\item{\code{nhoodGraph(x)}:}{Returns an \code{igraph} object representation of the
graph of neighbourhoods, with number of vertices equal to the number of neighbourhoods.}
\item{\code{nhoodAdjacency(x)}:}{Returns a matrix of \code{N} by \code{N} neighbourhoods with entries
of 1 where neighbourhods share cells, and 0 elsewhere.}
}
}

\section{Setters}{

In the following descriptions \code{x} is always a \linkS4class{Milo} object.
\describe{
\item{\code{graph(x) <- value}:}{Populates the graph slot with \code{value} -
this should be a valid graph representation in either \code{igraph} or \code{list} format.}
\item{\code{nhoodDistances(x) <- value}:}{Replaces the internally comptued neighbourhood
distances. This is normally computed internally during graph building, but can be defined
externally. Must be a list with one entry per neighbourhood containing the cell-to-cell distances for the
cells within that neighbourhood.}
\item{\code{nhoodCounts(x) <- value}:}{Replaces the neighbourhood counts matrix.
This is normally computed and assigned by \code{countCells}, however, it can also be user-defined.}
\item{\code{nhoodExpression(x) <- value}:}{Replaces the \code{nhoodExpression} slot. This is calculated
internally by \code{calcNhoodExpression}, which calculates the \code{mean} expression. An alternative
summary function can be used to assign an alternative in this way.}
\item{\code{nhoodIndex(x) <- value}:}{Replaces the list of neighbourhood indices. This is provided
purely for completeness, and is usually only set internally in \code{makeNhoods}.}
\item{\code{nhoodReducedDim(x) <- value}:}{Replaces the reduced dimensional
representation or projection of neighbourhoods. This can be useful for externally computed
projections or representations.}
\item{\code{nhoods(x) <- value}:}{Replaces the neighbourhood matrix. Generally use of this function
is discouraged, however, it may be useful for users to define their own bespoke neighbourhoods
by some means.}
\item{\code{nhoodGraph(x) <- value}:}{Populates the nhoodGraph slot with \code{value} -
this should be a valid graph representation in either \code{igraph} or \code{list} format.}
\item{\code{nhoodAdjacency(x) <- value}:}{Populates the nhoodAdjacency slot with \code{value} -
this should be a \code{N} by \code{N} matrix with elements denoting which neighbourhoods share cells}
}
}

\section{Miscellaneous}{

A collection of non-getter and setter methods that operate on \linkS4class{Milo} objects.
\describe{
\item{\code{show(x)}:}{Prints information to the console regarding the \code{\linkS4class{Milo}} object.}
}
}

\examples{
example(Milo, echo=FALSE)
show(milo)
}
\author{
Mike Morgan
}
