% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{getFrequencies}
\alias{getFrequencies}
\title{Calculate features frequencies for a given experiment in MiDAS object.}
\usage{
getFrequencies(
  object,
  experiment,
  carrier_frequency = FALSE,
  compare = FALSE,
  ref_pop = list(hla_alleles = c("USA NMDP African American pop 2", "USA NMDP Chinese",
    "USA NMDP European Caucasian", "USA NMDP Hispanic South or Central American",
    "USA NMDP Japanese", "USA NMDP North American Amerindian",
    "USA NMDP South Asian Indian"), kir_genes = c("USA California African American KIR",
    "USA California Asian American KIR", "USA California Caucasians KIR",
    "USA California Hispanic KIR")),
  ref = list(hla_alleles = allele_frequencies, kir_genes = kir_frequencies)
)
}
\arguments{
\item{object}{\code{\link{MiDAS}} object.}

\item{experiment}{Matrix or SummarizedExperiment object.}

\item{carrier_frequency}{Logical flag indicating if carrier frequency should
be returned.}

\item{compare}{Logical flag indicating if \code{hla_calls} frequencies
should be compared to reference frequencies given in \code{ref}.}

\item{ref_pop}{Named list of character vectors giving names of reference
populations in \code{ref} to compare with. Optionally vectors can be named,
then those names will be used as population names. Each vector should
correspond to a specific experiment.}

\item{ref}{Named list of reference frequencies data frames. Each element
should give reference for a specific experiment. See
\code{\link{allele_frequencies}} for an example on how reference
frequency data frame should be formatted.}
}
\value{
Data frame with features from selected experiment and their
  corresponding frequencies. Column \code{"term"} hold features names, 
  \code{"Counts"} hold number of feature occurrences, \code{"Freq"} hold 
  feature frequencies. If argument \code{compare} is set to \code{TRUE}, 
  further columns will hold frequencies in reference populations.
}
\description{
Calculate features frequencies for a given experiment in MiDAS object.
}
\examples{
# using default reference populations
getFrequencies(object = MiDAS_tut_object, 
               experiment = "hla_alleles", 
               compare = TRUE)

# using customized set of reference populations
getFrequencies(
  object = MiDAS_tut_object, 
  experiment = "hla_alleles", 
  compare = TRUE,
  ref_pop = list(
    hla_alleles = c("USA NMDP Chinese", "USA NMDP European Caucasian")
  ),
  ref = list(hla_alleles = allele_frequencies)
)

}
