% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_sort.R
\name{time_sort}
\alias{time_sort}
\title{Temporal Sorting Within Subjects}
\usage{
time_sort(x)
}
\arguments{
\item{x}{A metadata data.frame including the following columns:
time, subject, sample, signal. Or a phyloseq object.}
}
\value{
A list with sorted metadata (data.frame) for each subject.
}
\description{
Within each subject, sort samples by time and calculate
distance from the baseline point (minimum time).
}
\examples{
data(atlas1006)
pseq <- subset_samples(atlas1006, DNA_extraction_method == "r")
ts <- time_sort(meta(pseq))
}
\references{
See citation('microbiome')
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
