% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low_abundance.R
\name{low_abundance}
\alias{low_abundance}
\title{Low Abundance Index}
\usage{
low_abundance(x, detection = 0.2/100)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{detection}{Detection threshold for absence/presence
(strictly greater by default).}
}
\value{
A vector of indicators.
}
\description{
Calculates the concentration of low-abundance taxa below the
indicated detection threshold.
}
\details{
The low_abundance index gives the concentration of species at low
abundance, or the  relative proportion of rare species in [0,1].
The species that are below the indicated detection threshold are
considered rare. Note that population prevalence is not considered.
If the detection argument is a vector, then a data.frame is returned,
one column for each detection threshold.
}
\examples{
data(dietswap)
d <- low_abundance(dietswap, detection=0.2/100)
}
\seealso{
core_abundance, rarity, global
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
