% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot_abundance.R
\name{boxplot_abundance}
\alias{boxplot_abundance}
\title{Abundance Boxplot}
\usage{
boxplot_abundance(
  d,
  x,
  y,
  line = NULL,
  violin = FALSE,
  na.rm = FALSE,
  show.points = TRUE
)
}
\arguments{
\item{d}{\code{\link{phyloseq-class}} object}

\item{x}{Metadata variable to map to the horizontal axis.}

\item{y}{OTU to map on the vertical axis}

\item{line}{The variable to map on lines}

\item{violin}{Use violin version of the boxplot}

\item{na.rm}{Remove NAs}

\item{show.points}{Include data points in the figure}
}
\value{
A \code{\link{ggplot}} plot object
}
\description{
Plot phyloseq abundances.
}
\details{
The directionality of change in paired boxplot is indicated by
the colors of the connecting lines.
}
\examples{
data(peerj32)
p <- boxplot_abundance(peerj32$phyloseq, x='time', y='Akkermansia',
   line='subject')
}
\keyword{utilities}
