% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/runCCA.R
\name{getCCA}
\alias{getCCA}
\alias{addCCA}
\alias{getRDA}
\alias{addRDA}
\alias{runCCA}
\alias{calculateCCA}
\alias{getCCA,ANY-method}
\alias{getCCA,SummarizedExperiment-method}
\alias{addCCA,SingleCellExperiment-method}
\alias{calculateRDA}
\alias{runRDA}
\alias{getRDA,ANY-method}
\alias{getRDA,SummarizedExperiment-method}
\alias{addRDA,SingleCellExperiment-method}
\title{Canonical Correspondence Analysis and Redundancy Analysis}
\usage{
getCCA(x, ...)

addCCA(x, ...)

getRDA(x, ...)

addRDA(x, ...)

calculateCCA(x, ...)

runCCA(x, ...)

\S4method{getCCA}{ANY}(x, formula, data, ...)

\S4method{getCCA}{SummarizedExperiment}(
  x,
  formula = NULL,
  col.var = variables,
  variables = NULL,
  test.signif = TRUE,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = "counts",
  ...
)

\S4method{addCCA}{SingleCellExperiment}(x, altexp = NULL, name = "CCA", ...)

calculateRDA(x, ...)

runRDA(x, ...)

\S4method{getRDA}{ANY}(x, formula, data, ...)

\S4method{getRDA}{SummarizedExperiment}(
  x,
  formula = NULL,
  col.var = variables,
  variables = NULL,
  test.signif = TRUE,
  assay.type = assay_name,
  assay_name = exprs_values,
  exprs_values = NULL,
  dis.name = NULL,
  ...
)

\S4method{addRDA}{SingleCellExperiment}(x, altexp = NULL, name = "RDA", ...)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{additional arguments passed to vegan::cca or vegan::dbrda and
other internal functions.
\itemize{
\item \code{method} a dissimilarity measure to be applied in dbRDA and
possible following homogeneity test. (Default: \code{"euclidean"})

\item \code{scale}: \code{Logical scalar}. Should the expression values be
standardized? \code{scale} is disabled when using \code{*RDA} functions.
Please scale before performing RDA. (Default: \code{TRUE})

\item \code{na.action}: \code{function}. Action to take when missing
values for any of the variables in \code{formula} are encountered.
(Default: \code{na.fail})

\item \code{full} \code{Logical scalar}. Should all the results from the
significance calculations be returned. When \code{FALSE}, only
summary tables are returned. (Default: \code{FALSE})

\item \code{homogeneity.test}: \code{Character scalar}. Specifies
the significance test used to analyse
\code{\link[vegan:betadisper]{vegan::betadisper}} results.
Options include 'permanova'
(\code{\link[vegan:permutest]{vegan::permutest}}), 'anova'
(\code{\link[stats:anova]{stats::anova}}) and 'tukeyhsd'
(\code{\link[stats:TukeyHSD]{stats::TukeyHSD}}).
(Default: \code{"permanova"})

\item \code{permutations}: \code{Integer scalar}. Specifies the number of
permutations for significance testing in \code{vegan::anova.cca}.
(Default: \code{999})

\item \code{subset.result}: \code{Logical result}. Specifies whether to
subset \code{x} to match the result if some samples were removed during
calculation. (Default: \code{TRUE})

\item \code{binary}: \code{Logical scalar}. Whether to perform
presence/absence transformation before dissimilarity calculation. For
Jaccard index the default is \code{TRUE}. For other dissimilarity metrics,
please see \code{\link[vegan:vegdist]{vegdist}}.
}}

\item{formula}{\code{formula}. If \code{x} is a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
a formula can be supplied. Based on the right-hand side of the given formula
\code{colData} is subset to \code{col.var}.

\code{col.var} and \code{formula} can be missing, which turns the CCA
analysis into a CA analysis and dbRDA into PCoA/MDS.}

\item{data}{\code{data.frame} or coarcible to one. The covariance table
including covariates defined by \code{formula}.}

\item{col.var}{\code{Character scalar}. When \code{x} is a
\code{SummarizedExperiment},\code{col.var} can be used to specify variables
from \code{colData}.}

\item{variables}{Deprecated. Use \code{col.var} instead.}

\item{test.signif}{\code{Logical scalar}. Should the PERMANOVA and analysis
of multivariate homogeneity of group dispersions be performed.
(Default: \code{TRUE})}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{NULL})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{exprs_values}{Deprecated. Use \code{assay.type} instead.}

\item{altexp}{\code{Character scalar} or \code{integer scalar}. Specifies an
alternative experiment containing the input data.}

\item{name}{\code{Character scalar}. A name for the \code{reducedDim()}
where results will be stored. (Default: \code{"CCA"})}

\item{dis.name}{\code{Character scalar}. Specifies the name of dissimilarity
matrix from \code{metadata} slot used in calculation. (Default: \code{NULL})}
}
\value{
For \code{getCCA} a matrix with samples as rows and CCA dimensions as
columns. Attributes include output from \code{\link[vegan:scores]{scores}},
eigenvalues, the \code{cca}/\code{rda} object and significance analysis
results.

For \code{addCCA} a modified \code{x} with the results stored in
\code{reducedDim} as the given \code{name}.
}
\description{
These functions perform Canonical Correspondence Analysis on data stored
in a \code{SummarizedExperiment}.
}
\details{
*CCA functions utilize \code{vegan:cca} and *RDA functions
\code{vegan:dbRDA}. By default, dbRDA is done with euclidean distances, which
is equivalent to RDA. \code{col.var} and \code{formula} can be missing,
which turns the CCA analysis into a CA analysis and dbRDA into PCoA/MDS.

Significance tests are done with \code{vegan:anova.cca} (PERMANOVA). Group
dispersion, i.e., homogeneity within groups is analyzed with
\code{\link[vegan:betadisper]{vegan::betadisper}}
(multivariate homogeneity of groups dispersions
(variances)) and statistical significance of homogeneity is tested with a
test specified by \code{homogeneity.test} parameter.
}
\examples{
library(miaViz)
data("enterotype", package = "mia")
tse <- enterotype

# Perform CCA and exclude any sample with missing ClinicalStatus
tse <- addCCA(
    tse,
    assay.type = "counts",
    formula = data ~ ClinicalStatus,
    na.action = na.exclude
    )

# Plot CCA
plotCCA(tse, "CCA", colour_by = "ClinicalStatus")

# Fetch significance results
getReducedDimAttribute(tse, dimred = "CCA", name = "significance")

tse <- transformAssay(tse, method = "relabundance")

# Specify dissimilarity measure
tse <- addRDA(
    tse,
    formula = data ~ ClinicalStatus,
    assay.type = "relabundance",
    method = "bray",
    name = "RDA_bray",
    na.action = na.exclude
    )

# To scale values when using *RDA functions, use
# transformAssay(MARGIN = "features", ...)
tse <- transformAssay(tse, method = "standardize", MARGIN = "features")

# Data might include taxa that do not vary. Remove those because after
# z-transform their value is NA
tse <- tse[rowSums(is.na(assay(tse, "standardize"))) == 0, ]

# Calculate RDA
tse <- addRDA(
   tse,
   formula = data ~ ClinicalStatus,
   assay.type = "standardize",
   name = "rda_scaled",
   na.action = na.omit
   )

# Plot RDA
plotRDA(tse, "rda_scaled", colour_by = "ClinicalStatus")

# A common choice along with PERMANOVA is ANOVA when statistical significance
# of homogeneity of groups is analysed. Moreover, full significance test
# results can be returned.
tse <- transformAssay(tse, method = "clr", pseudocount = 1)
tse <- addRDA(
    tse,
    assay.type = "clr",
    formula = data ~ ClinicalStatus,
    homogeneity.test = "anova",
    full = TRUE
    )

# Example showing how to pass extra parameters, such as 'permutations',
# to anova.cca
tse <- addRDA(
    tse,
    assay.type = "clr",
    formula = data ~ ClinicalStatus,
    permutations = 500
    )

# In dbRDA, dissimilarity matrix is calculated internally which is
# computationally heavy operation. If you have large number of samples, and
# you want to fit multiple dbRDA models, you might want to consider
# pre-calculation of dissimilarity matrix as the same matrix will be used for
# all models. You can then run dbRDA with the pre-calculated dissimilarity
# avoiding redundant dissimilarity calculations.
tse <- addDissimilarity(tse, assay.type = "relabundance", method = "bray")
tse <- addRDA(
    tse,
    formula = data ~ ClinicalStatus,
    dis.name = "bray",
    name = "RDA_precalc_bray",
    na.action = na.exclude
    )

}
\seealso{
For more details on the actual implementation see
\code{\link[vegan:cca]{cca}} and \code{\link[vegan:dbrda]{dbrda}}
}
