% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/cluster.R
\name{addCluster}
\alias{addCluster}
\alias{addCluster,SummarizedExperiment-method}
\title{Clustering wrapper}
\usage{
addCluster(
  x,
  BLUSPARAM,
  assay.type = assay_name,
  assay_name = "counts",
  by = MARGIN,
  MARGIN = "rows",
  full = FALSE,
  name = "clusters",
  clust.col = "clusters",
  ...
)

\S4method{addCluster}{SummarizedExperiment}(
  x,
  BLUSPARAM,
  assay.type = assay_name,
  assay_name = "counts",
  by = MARGIN,
  MARGIN = "rows",
  full = FALSE,
  name = "clusters",
  clust.col = "clusters",
  ...
)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{BLUSPARAM}{A \linkS4class{BlusterParam} object specifying the algorithm to use.}

\item{assay.type}{\code{Character scalar}. Specifies the name of the
assay used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{by}{\code{Character scalar}. Determines if association is calculated
row-wise / for features ('rows') or column-wise / for samples ('cols').
Must be \code{'rows'} or \code{'cols'}.}

\item{MARGIN}{Deprecated. Use \code{by} instead.}

\item{full}{Logical scalar indicating whether the full clustering statistics should be returned for each method.}

\item{name}{\code{Character scalar}. The name to store the result in
\code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{metadata}}}

\item{clust.col}{\code{Character scalar}. Indicates the name of the
\code{rowData} (or \code{colData}) where the data will be stored.
(Default: \code{"clusters"})}

\item{...}{Additional parameters to use altExps for example}
}
\value{
\code{addCluster} returns an object of the same type as the \code{x}
parameter with clustering information named \code{clusters} stored in
\code{colData} or \code{rowData}.
}
\description{
This function returns a \code{SummarizedExperiment} with clustering
information in its colData or rowData
}
\details{
This is a wrapper for the \code{clusterRows} function from the
\link[bluster]{bluster} package.

When setting \code{full = TRUE}, the clustering information will be stored in
the metadata of the object.

By default, clustering is done on the features.
}
\examples{
library(bluster)
data(GlobalPatterns, package = "mia")
tse <- GlobalPatterns

# Cluster on rows using Kmeans
tse <- addCluster(tse, KmeansParam(centers = 3))

# Clustering done on the samples using Hclust
tse <- addCluster(tse,
               by = "samples",
               HclustParam(metric = "bray", dist.fun = vegan::vegdist))

# Getting the clusters
colData(tse)$clusters

}
