% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{diff_module}
\alias{diff_module}
\title{diff_module}
\usage{
diff_module(
  Module.group1,
  Module.group2,
  sim.cutoff = 0.8,
  sim.method = "Simpson"
)
}
\arguments{
\item{Module.group1}{List object, the first list of module group.}

\item{Module.group2}{List object, the second list of module group.}

\item{sim.cutoff}{Similarity cutoff between modules, the interval is [0 1].}

\item{sim.method}{Methods for calculating similatiry between two modules, select one of three methods (Simpson, Jaccard and Lin). Default method is Simpson.}
}
\value{
A list of differential modules
}
\description{
Inferring differential modules between two list of module groups
}
\examples{
library(GSEABase)
data(BRCASampleData)
modulegenes_WGCNA_all <- module_WGCNA(ceRExp, mRExp)
modulegenes_WGCNA_1 <- module_WGCNA(ceRExp[-1, ], mRExp[-1, ])
Differential_module <- diff_module(geneIds(modulegenes_WGCNA_all), geneIds(modulegenes_WGCNA_1))

}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
