% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbClassesAndMethods.R
\docType{class}
\name{MirnaDb-class}
\alias{.MirnaDb}
\alias{MirnaDb}
\alias{MirnaDb-class}
\alias{columns}
\alias{columns,MirnaDb-method}
\alias{keys}
\alias{keys,MirnaDb-method}
\alias{keytypes}
\alias{keytypes,MirnaDb-method}
\alias{select}
\alias{select,MirnaDb-method}
\title{Database class}
\usage{
columns(x)
keytypes(x)
keys(x, keytype, ...)
select(x, keys, columns, keytype, ...)

\S4method{columns}{MirnaDb}(x)

\S4method{keytypes}{MirnaDb}(x)

\S4method{keys}{MirnaDb}(x, keytype, ...)

\S4method{select}{MirnaDb}(x, keys, columns, keytype, ...)
}
\arguments{
\item{x}{the \code{MirnaDb} object}

\item{keytype}{the keytype that matches the keys used; the table in which 
the search should be performed.}

\item{...}{any optional arguments}

\item{keys}{the key to select records for from the database - miRNA name; 
all possible keys (miRNAs) are returned by using the \code{keys} method.}

\item{columns}{in this case same as \code{keytype}, the table in which the 
search should be performed, this value specifies the source of predictions 
as well as species; as with \code{keys}, all possible columns are returned 
by using the \code{columns} method.}
}
\value{
string vectors, for \code{select} a data.frame with target 
genes and scores
}
\description{
object of \code{MirnaDb} class holds the sqlite database 
connection, and extends \code{AnnotationDb} class from AnnotationDbi 
package. \code{columns}, \code{keys}, \code{keytypes} and \code{select} 
methods allow access to database tables and retrieval of miRNA target 
information.

\code{select} is the most important method, allows querying the 
database for predictions from a specific source and species for a 
given miRNA
}
\examples{
#first load the annotations
require(miRNAtap.db)
#see all available tables
keytypes(miRNAtap.db)
}
\author{
Maciej Pajak \email{m.pajak@sms.ed.ac.uk}
}

