% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRNANameConverter.R
\name{assessMiRNASwappingMIMAT}
\alias{assessMiRNASwappingMIMAT}
\title{Check if given miRNA names can be assigned to unique MIMAT 
accessions among all versions}
\usage{
assessMiRNASwappingMIMAT(this, miRNAs, verbose = FALSE)
}
\arguments{
\item{this}{Object of class 'MiRNANameConverter'}

\item{miRNAs}{A character vector of miRNA names}

\item{verbose}{A boolean to either show more (TRUE) or less information
(FALSE)}
}
\value{
A character vector containing miRNA names that do not have a unique
MIMAT ID
}
\description{
This function checks if the names from a given set of mature
miRNAs have a unique MIMAT ID.
Check if given miRNA names can be assigned to unique MIMAT accessions among
all versions

This function checks if the names from a given set of mature miRNAs
have a unique MIMAT ID.
}
\details{
Although the majority of miRNA names can be assigned to a unique MIMAT ID
(accession) some miRNAs changed MIMAT ID in different versions. This function
takes the input miRNA names and checks each one of them if they have a unique
MIMAT ID over all versions. If a miRNA changes MIMAT ID in a version it will
be comprised in the return vector.
}
\author{
Stefan Haunsberger
}
