% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{Extopk}
\alias{Extopk}
\title{Extract top k miRNA-mRNA interactions}
\usage{
Extopk(cormat, topk)
}
\arguments{
\item{cormat}{the correlation matrix that need to be extracted with columns are miRNAs and rows are mRNAs}

\item{topk}{the number of interactions that need to be extracted.}
}
\value{
topk interactions
}
\description{
Rank the miRNA-mRNA interactions based on absolute values of the correlations/scores/causal effects, and return
the topk interactions.
}
\examples{
dataset=system.file("extdata", "ToyEMT.csv", package="miRLAB")
EMTresults=Pearson(dataset, 1:3, 4:18)
top10=Extopk(EMTresults, 10)
}
