% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{Borda}
\alias{Borda}
\title{Ensemble method for miRNA target prediction using Borda count election}
\usage{
Borda(listCEmatrices)
}
\arguments{
\item{listCEmatrices}{a list of matrices that include the correlation coefficients/causal effects/scores resulting from different target prediction methods}
}
\value{
a matrix of ranking scores (averaging all the rankings from different methods). Columns are miRNAs and rows are mRNAs
}
\description{
Use the Borda count election method to integrate the rankings from different miRNA target prediction methods
}
\examples{
dataset=system.file("extdata", "ToyEMT.csv", package="miRLAB")
ps=Pearson(dataset, cause=1:3, effect=4:18)
ida=IDA(dataset, cause=1:3, effect=4:18)
borda=Borda(list(ps, ida))
}
\references{
1. Le, T.D., Zhang, J., Liu, L., and Li, J. (2015) Ensemble Methods for miRNA Target Prediction from Expression Data, Plos ONE.

2. Marbach, D., Costello, J.C., Kuffner, R., Vega, N.M., Prill, R.J., Camacho, D.M., Allison, K.R. and DREAM5 Consortium (2012). Wisdom of crowds for robust gene network inference. Nat. Methods, 9, 796-804.
}
