% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_methylsig.R
\name{diff_methylsig}
\alias{diff_methylsig}
\title{Calculates differential methylation statistics using a Beta-binomial approach}
\usage{
diff_methylsig(
  bs,
  group_column,
  comparison_groups,
  disp_groups,
  local_window_size = 0,
  local_weight_function,
  t_approx = TRUE,
  n_cores = 1
)
}
\arguments{
\item{bs}{a \code{BSseq} object.}

\item{group_column}{a \code{character} string indicating the column of \code{pData(bs)} to use for determining group membership.}

\item{comparison_groups}{a named \code{character} vector indicating the \code{case} and \code{control} factors of \code{group_column} for the comparison.}

\item{disp_groups}{a named \code{logical} vector indicating the whether to use \code{case}, \code{control}, or both to estimate the dispersion.}

\item{local_window_size}{an \code{integer} indicating the size of the window for use in determining local information to improve mean and dispersion parameter estimations. In addition to a the distance constraint, a maximum of 5 loci upstream and downstream of the locus are used. The default is \code{0}, indicating no local information is used.}

\item{local_weight_function}{a weight kernel function. The default is the tri-weight kernel function defined as \code{function(u) = (1-u^2)^3}. The domain of any given weight function should be [-1,1], and the range should be [0,1].}

\item{t_approx}{a \code{logical} value indicating whether to use squared t approximation for the likelihood ratio statistics. Chi-square approximation (\code{t_approx = FALSE}) is recommended when the sample size is large.  Default is \code{TRUE}.}

\item{n_cores}{an \code{integer} denoting how many cores should be used for differential methylation calculations.}
}
\value{
A \code{GRanges} object containing the following \code{mcols}:
\describe{
  \item{meth_case:}{ Methylation estimate for case. }
  \item{meth_control:}{ Methylation estimate for control. }
  \item{meth_diff:}{ The difference \code{meth_case - meth_control}. }
  \item{direction:}{ The group for which the locus is hyper-methylated. Note, this is not subject to significance thresholds. }
  \item{pvalue:}{ The p-value from the t-test (\code{t_approx = TRUE}) or the Chi-Square test (\code{t_approx = FALSE}). }
  \item{fdr:}{ The Benjamini-Hochberg adjusted p-values using \code{p.adjust(method = 'BH')}. }
  \item{disp_est:}{ The dispersion estimate. }
  \item{log_lik_ratio:}{ The log likelihood ratio. }
  \item{df:}{ Degrees of freedom used when \code{t_approx = TRUE}. }
}
}
\description{
The function calculates differential methylation statistics between two groups of samples using a beta-binomial approach to calculate differential methylation statistics, accounting for variation among samples within each group. The function can be applied to a \code{BSseq} object subjected to \code{filter_loci_by_coverage()}, \code{filter_loci_by_snps()}, \code{filter_loci_by_group_coverage()} or any combination thereof. Moreover, the function can be applied to a \code{BSseq} object which has been tiled with \code{tile_by_regions()} or \code{tile_by_windows()}.
}
\examples{
data(BS.cancer.ex, package = 'bsseqData')

bs = filter_loci_by_group_coverage(
    bs = BS.cancer.ex,
    group_column = 'Type',
    c('cancer' = 2, 'normal' = 2))

small_test = bs[seq(50)]

diff_gr = diff_methylsig(
    bs = small_test,
    group_column = 'Type',
    comparison_groups = c('case' = 'cancer', 'control' = 'normal'),
    disp_groups = c('case' = TRUE, 'control' = TRUE),
    local_window_size = 0,
    t_approx = TRUE,
    n_cores = 1)

}
