% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/diffMeth.R, R/methylDBClasses.R
\docType{methods}
\name{getData}
\alias{getData}
\alias{getData,methylBase-method}
\alias{getData,methylRaw-method}
\alias{getData,methylDiff-method}
\alias{getData,methylRawDB-method}
\alias{getData,methylBaseDB-method}
\alias{getData,methylDiffDB-method}
\title{get the data slot from the methylKit objects}
\usage{
getData(x)

\S4method{getData}{methylBase}(x)

\S4method{getData}{methylRaw}(x)

\S4method{getData}{methylDiff}(x)

\S4method{getData}{methylRawDB}(x)

\S4method{getData}{methylBaseDB}(x)

\S4method{getData}{methylDiffDB}(x)
}
\arguments{
\item{x}{an \code{\link{methylBase}},\code{\link{methylBaseDB}},
\code{\link{methylRaw}},\code{\link{methylRawDB}} or 
\code{\link{methylDiff}} object}
}
\value{
data frame for methylation events
}
\description{
The functions retrieves the table containing methylation information from 
\code{methylKit} Objects.
The data retrived from this function is of a \code{\link{data.frame}}. 
This is basically containing all relevant methylation information per 
genomic region or base.
}
\examples{
data(methylKit)

# following commands show first lines of returned 
# data.frames from getData() function
head(
getData(methylBase.obj)
)

head( getData(methylDiff.obj))

head(getData(methylRawList.obj[[1]]))


}
