% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceMethods.R
\name{runPermutation}
\alias{runPermutation}
\title{Run all permutations on the specified multi-generational dataset}
\usage{
runPermutation(
  methylKitData,
  type = c("both", "sites", "tiles"),
  outputDir = "output",
  runObservationAnalysis = TRUE,
  nbrPermutations = 1000,
  nbrCores = 1,
  nbrCoresDiffMeth = 1,
  minReads = 10,
  minMethDiff = 10,
  qvalue = 0.01,
  maxPercReads = 99.9,
  destrand = FALSE,
  minCovBasesForTiles = 0,
  tileSize = 1000,
  stepSize = 1000,
  vSeed = -1,
  restartCalculation = FALSE,
  saveInfoByGeneration = FALSE
)
}
\arguments{
\item{methylKitData}{a \code{list} of \code{methylRawList} entries or the
name of the RDS file containing the \code{list}. Each
\code{methylRawList} entry must contain all the \code{methylRaw} entries
related to one generation (first entry = first generation, second
entry = second generation, etc..). The number of generations must
correspond to the number
of entries in the \code{methylKitData}. At least 2 generations
must be present to make a permutation analysis. More information can be
found in the methylKit package.}

\item{type}{One of the "sites","tiles" or "both" strings. Specifies the type
of differentially methylated elements should be returned. For
retrieving differentially methylated bases type="sites"; for
differentially methylated regions type="tiles". Default: "both".}

\item{outputDir}{a string, the name of the directory that will contain
the results of the permutation. If the directory does not
exist, it will be created. Default: \code{"output"}.}

\item{runObservationAnalysis}{a \code{logical}, when
\code{runObservationAnalysis} = \code{TRUE}, a CpG analysis on the
observed dataset is done. Default: \code{TRUE}.}

\item{nbrPermutations, }{a positive \code{integer}, the total number of
permutations that is going to be done. Default: \code{1000}.}

\item{nbrCores}{a positive \code{integer}, the number of cores to use when
processing the analysis. Default: \code{1} and always \code{1} for Windows.}

\item{nbrCoresDiffMeth}{a positive \code{integer}, the number of cores
to use for parallel differential methylation calculations. The parameter is
used for both sites and tiles analysis. The parameter
corresponds to the \code{num.cores} parameter in the package
\code{methylKit}.
Default: \code{1} and always \code{1} for Windows.}

\item{minReads}{a positive \code{integer} Bases and regions having lower
coverage than this count are discarded. The parameter
corresponds to the \code{lo.count} parameter in the package
\code{methylKit}.}

\item{minMethDiff}{a positive \code{double} between [0,100], the absolute
value of methylation percentage change between cases and controls. The
parameter corresponds to the \code{difference} parameter in
the methylKit package. Default: \code{10}.}

\item{qvalue}{a positive \code{double} between [0,1], the cutoff
for qvalue of differential methylation statistics. Default: \code{0.01}.}

\item{maxPercReads}{a \code{double} between [0,100], the percentile of read
counts that is going to be used as an upper cutoff. Bases or regions
having higher
coverage than this percentile are discarded. The parameter is used for
both CpG sites and tiles analysis. The parameter
corresponds to the \code{hi.perc} parameter in the package \code{methylKit}.
Default: \code{99.9}.}

\item{destrand}{a \code{logical}, when \code{TRUE} will merge reads on both
strands of a CpG dinucleotide to provide better coverage. Only advised
when looking at CpG methylation. The parameter is used for both CpG
sites and tiles analysis.
Default: \code{FALSE}.}

\item{minCovBasesForTiles}{a non-negative \code{integer}, the minimum
number of bases to be covered in a given tiling window. The parameter
corresponds to the \code{cov.bases} parameter in the package
\code{methylKit}.
Only used when \code{doingTiles} =
\code{TRUE}. Default: \code{0}.}

\item{tileSize}{a positive \code{integer}, the size of the tiling window.
The parameter corresponds to the \code{win.size} parameter in
the package \code{methylKit}. Only
used when \code{doingTiles} = \code{TRUE}. Default: \code{1000}.}

\item{stepSize}{a positive \code{integer}, the step size of tiling windows.
The parameter corresponds to the \code{stepSize} parameter in
the package \code{methylKit}. Only
used when \code{doingTiles} = \code{TRUE}. Default: \code{1000}.}

\item{vSeed}{a \code{integer}, a seed used when reproducible results are
needed. When a value inferior or equal to zero is given, a random integer
is used. Default: \code{-1}.}

\item{restartCalculation}{a \code{logical}, when \code{TRUE}, only
permutations that don't have an associated RDS result file are run. Useful
to restart a permutation analysis that has been interrupted. Beware that
the parameters have to be identical except for this one.}

\item{saveInfoByGeneration}{a \code{logical}, when \code{TRUE}, the
information about differentially methylated sites and tiles for each
generation is saved in a RDS file. The information is saved in a different
file for each permutation. The files are saved in the directory specified
by the \code{outputDir} parameter.}
}
\value{
\code{0}.
}
\description{
Run a permutation analysis, based on Monte Carlo sampling,
for testing the hypothesis that the number of conserved differentially
methylated elements (sites, tiles or both), between
several generations, is associated to an effect inherited from a treatment
and that stochastic effect can be dismissed.

The multi-generational dataset or the name of the RDS file that contains the
dataset can be used as input.

The observation analysis can also be run (optional). All permutation
results are saved in RDS files.
}
\examples{

## Load methylKit information
data(samplesForTransgenerationalAnalysis)

## Run a permutation analysis using the methylKit dataset
## A real analysis would require a much higher number of permutations
runPermutation(methylKitData = samplesForTransgenerationalAnalysis,
    outputDir = "test_01", runObservationAnalysis = FALSE, type = "sites",
    nbrPermutations = 2, vSeed = 221)

## Get results
results_01 <- loadAllRDSResults(analysisResultsDir = NULL,
    permutationResultsDir = "test_01", doingSites = TRUE,
    doingTiles = FALSE)

## Remove results directory
if (dir.exists("test_01")) {
    unlink("test_01", recursive = TRUE, force = TRUE)
}

## Path to a methylKit RDS file
methylFile <- system.file("extdata", "methylObj_001.RDS",
    package = "methylInheritance")

## Run a permutation analysis using RDS file name
## A real analysis would require a much higher number of permutations
runPermutation(methylKitData = methylFile, type = "tiles",
    outputDir = "test_02", nbrPermutations = 2, minCovBasesForTiles = 10,
    vSeed = 2001)

## Get results
results_02 <- loadAllRDSResults(analysisResultsDir = NULL,
    permutationResultsDir = "test_02", doingSites = FALSE,
    doingTiles = TRUE)

## Remove results directory
if (dir.exists("test_02")) {
    unlink("test_02", recursive = TRUE, force = TRUE)
}

}
\seealso{
\code{\link{mergePermutationAndObservation}} for detail
description, in the Value section, of the
\code{methylInheritanceAllResults} object as
well as its \code{PERMUTATION} section.
}
\author{
Astrid Deschenes, Pascal Belleau
}
