% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceMethods.R
\name{runObservation}
\alias{runObservation}
\title{Run a differential methylation analysis on multi-generational
dataset}
\usage{
runObservation(
  methylKitData,
  type = c("both", "sites", "tiles"),
  outputDir = "output",
  nbrCoresDiffMeth = 1,
  minReads = 10,
  minMethDiff = 10,
  qvalue = 0.01,
  maxPercReads = 99.9,
  destrand = FALSE,
  minCovBasesForTiles = 0,
  tileSize = 1000,
  stepSize = 1000,
  vSeed = -1,
  restartCalculation = FALSE,
  saveInfoByGeneration = FALSE
)
}
\arguments{
\item{methylKitData}{a \code{list} of \code{methylRawList} entries or the
name of the RDS file containing the list. Each
\code{methylRawList} contains all the \code{methylRaw} entries related to
one generation (first entry = first generation, second entry = second
generation, etc..). The number of generations must correspond to the number
of entries in the \code{methylKitData}.At least 2 generations
must be present to calculate the conserved elements. More information can
be found in the methylKit package.}

\item{type}{One of the "sites","tiles" or "both" strings. Specifies the type
of differentially methylated elements should be returned. For
retrieving differentially methylated bases type="sites"; for
differentially methylated regions type="tiles". Default: "both".}

\item{outputDir}{a string, the name of the directory that will contain
the results of the analysis. If the directory does not
exist, it will be created. Default: \code{"output"}.}

\item{nbrCoresDiffMeth}{a positive \code{integer}, the number of cores
to use for parallel differential methylation calculations.The parameter is
used for both sites and tiles analysis. The parameter
corresponds to the \code{num.cores} parameter in the package
\code{methylKit}.
Default: \code{1} and always \code{1} for Windows.}

\item{minReads}{a positive \code{integer} Bases and regions having lower
coverage than this count are discarded. The parameter
correspond to the \code{lo.count} parameter in the package \code{methylKit}.}

\item{minMethDiff}{a positive \code{double} between [0,100], the absolute
value of methylation percentage change between cases and controls. The
parameter corresponds to the \code{difference} parameter in
the methylKit package. Default: \code{10}.}

\item{qvalue}{a positive \code{double} between [0,1], the cutoff
for qvalue of differential methylation statistics. Default: \code{0.01}.}

\item{maxPercReads}{a \code{double} between [0,100], the percentile of read
counts that is going to be used as an upper cutoff. Bases or regions
having higher
coverage than this percentile are discarded. The parameter is used for
both CpG sites and tiles analysis. The parameter
corresponds to the \code{hi.perc} parameter in the package \code{methylKit}.
Default: \code{99.9}.}

\item{destrand}{a \code{logical}, when \code{TRUE} will merge reads on both
strands of a CpG dinucleotide to provide better coverage. Only advised
when looking at CpG methylation. Parameter used for both CpG
sites and tiles analysis.
Default: \code{FALSE}.}

\item{minCovBasesForTiles}{a non-negative \code{integer}, the minimum
number of bases to be covered in a given tiling window. The parameter
corresponds to the \code{cov.bases} parameter in the package
\code{methylKit}.
Only used when \code{doingTiles} =
\code{TRUE}. Default: \code{0}.}

\item{tileSize}{a positive \code{integer}, the size of the tiling window.
The parameter corresponds to the \code{win.size} parameter in
the package \code{methylKit}. Only
used when \code{doingTiles} = \code{TRUE}. Default: \code{1000}.}

\item{stepSize}{a positive \code{integer}, the step size of tiling windows.
The parameter corresponds to the \code{stepSize} parameter in
the package \code{methylKit}. Only
used when \code{doingTiles} = \code{TRUE}. Default: \code{1000}.}

\item{vSeed}{a \code{integer}, a seed used when reproducible results are
needed. When a value inferior or equal to zero is given, a random integer
is used. Default: \code{-1}.}

\item{restartCalculation}{a \code{logical}, when \code{TRUE}, only
permutations that don't have a RDS result final are run. Useful
to restart a permutation analysis that has been interrupted. Beware that
the parameters have to be identical except for this one.}

\item{saveInfoByGeneration}{a \code{logical}, when \code{TRUE}, the
information about differentially methylated sites and tiles for each
generation is saved in a RDS file. The files are saved in the directory
specified by the \code{outputDir} parameter.}
}
\value{
\code{0}.
}
\description{
Run a differential methylation analysis on each generation
present in a dataset. The number of conserved differentially
methylated elements (sites, tile or both) between generations is
them calculated. The
methylKit package is used to identify the differentially methylated
elements.

The multi-generational dataset or the name of the RDS file that contains
the dataset can be used as input.

The results can also be saved in RDS file (optional).
}
\examples{

## Load methylation information
data(samplesForTransgenerationalAnalysis)

## Run an observation analysis
runObservation(methylKitData = samplesForTransgenerationalAnalysis,
    outputDir = "test", type = "sites", vSeed = 221)

## Load the results
results <- loadAllRDSResults(analysisResultsDir = "test",
    permutationResultsDir = NULL, doingSites = TRUE, doingTiles = FALSE)

## Print the results
results

## Remove directory
if (dir.exists("test")) {
    unlink("test", recursive = TRUE, force = FALSE)
}

}
\seealso{
\code{\link{mergePermutationAndObservation}}  for detail
description, in the Value section, of the \code{OBSERVATION} section of the
\code{methylInheritanceAllResults} object.
}
\author{
Astrid Deschenes, Pascal Belleau
}
