% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGS.R
\name{getGS}
\alias{getGS}
\title{Get Gene Sets}
\usage{
getGS(geneids, GS.type)
}
\arguments{
\item{geneids}{A vector contains all gene ids of interest. Gene ids should
be gene symbol.}

\item{GS.type}{A string. "GO", "KEGG", or "Reactome".}
}
\value{
A list contains all gene sets of
interest and their corresponding genes.
}
\description{
This function gets gene sets information.
}
\examples{
geneids = c("FKBP5", "NDUFA1", "STAT5B")
GO.list = getGS(geneids, "KEGG")
head(GO.list)
}
\references{
Carlson M (2017). org.Hs.eg.db:
Genome wide annotation for Human. R package version 3.5.0.

Ligtenberg W (2017). reactome.db:
A set of annotation maps for reactome. R package version 1.62.0.
}
