% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDescription.R
\name{getDescription}
\alias{getDescription}
\title{Get gene set description}
\usage{
getDescription(GSids, GS.type)
}
\arguments{
\item{GSids}{A vector contains gene set IDs.}

\item{GS.type}{A string. "GO", "KEGG", or "Reactome".}
}
\value{
A vector contains gene sets description.
}
\description{
This function gets description of gene sets.
}
\examples{
GSids = c("GO:0007389", "GO:0000978", "GO:0043062")
Description = getDescription(GSids, "GO")
head(Description)
}
\references{
Carlson M (2018). GO.db: A set of annotation maps describing 
the entire Gene Ontology. R package version 3.6.0.

Yu G, Wang L, Han Y, He Q (2012). clusterProfiler: an R package 
for comparing biological themes among gene clusters. OMICS: A Journal 
of Integrative Biology, 16(5), 284-287.

Ligtenberg W (2017). reactome.db:
A set of annotation maps for reactome. R package version 1.62.0.
}
