% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateMissingData.R
\name{generateMissingData}
\alias{generateMissingData}
\title{Generation of artificial missing values}
\usage{
generateMissingData(beta, lambda = NULL)
}
\arguments{
\item{beta}{a numeric data matrix into which one wants to add some missing values}

\item{lambda}{a number, parameter of the Poisson distribution that will 
indicate how many samples will have missing values in each selected probe.}
}
\value{
A list with two slots: a numeric data matrix with generated NAs in 
some entries and a list of positions of those NAs.
}
\description{
This function generates missing values for the simulation purposes 
(to apply \emph{methyLImp} method and then compare the imputed values with 
the true ones that have been replaced by NAs). 
First, we randomly choose 3\% of all probes. 
Then for each of the chosen probes, we randomly define the number of NAs 
from a Poisson distribution with \eqn{\lambda}, appropriate to the sample 
size of the dataset (unless specified by the user, here we use 
\eqn{\lambda = 0.15 * \#samples + 0.2}). Finally, these amount of NAs is 
randomly placed among the samples.
}
\examples{
data(beta)
beta_with_nas <- generateMissingData(beta, lambda = 3.5)
}
