% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflateMethylome.R
\name{inflateMethylome}
\alias{inflateMethylome}
\title{Inflate an imported methylation extractor file}
\usage{
inflateMethylome(methylome, methylome.full)
}
\arguments{
\item{methylome}{A \code{\link[GenomicRanges]{GRanges-class}} with methylation counts.}

\item{methylome.full}{A \code{\link[GenomicRanges]{GRanges-class}} with positions for all cytosines or a file with such an object.}
}
\value{
The \code{methylome.full} object with added metadata column 'counts'.
}
\description{
Inflate an imported methylation extractor file to contain all cytosine positions. This is useful to obtain a full methylome, including non-covered cytosines, because most methylation extractor programs only report covered cytosines.
}
\examples{
## Get an example file in BSSeeker format
file <- system.file("extdata","arabidopsis_bsseeker.txt.gz", package="methimpute")
bsseeker.data <- importBSSeeker(file)
bsseeker.data

## Inflate to full methylome (including non-covered sites)
data(arabidopsis_toydata)
full.methylome <- inflateMethylome(bsseeker.data, arabidopsis_toydata)
full.methylome

}
