% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{filterAnchors}
\alias{filterAnchors}
\title{Filter Outlier Ordered Pairs}
\usage{
filterAnchors(
  rts,
  fit,
  vals,
  outlier,
  coef,
  iterFilter,
  prop,
  bs,
  m,
  family,
  method,
  optimizer,
  control,
  message,
  ...
)
}
\arguments{
\item{rts}{Data frame of ordered retention time pairs.}

\item{fit}{Either "gam" for GAM fits, or "loess" for loess fits}

\item{vals}{numeric values: k values for GAM fits, spans for loess fits}

\item{outlier}{Thresholding method for outlier dection. If "MAD", the
threshold is the mean absolute deviation (MAD) times \code{coef}; if
"boxplot", the threshold is \code{coef} times IQR plus 3rd quartile of
a model's absolute residual values.}

\item{coef}{numeric (> 1) multiplier for determining thresholds for outliers
(see \code{outlier} argument)}

\item{iterFilter}{integer number of outlier filtering iterations}

\item{prop}{numeric. A point is excluded if deemed a residual in more than
this proportion of fits. Must be between 0 & 1.}

\item{bs}{character. Choice of spline method from mgcv; either "bs" or "ps"}

\item{m}{integer. Basis and penalty order for GAM; see ?mgcv::s}

\item{family}{character. Choice of mgcv family; see: ?mgcv::family.mgcv}

\item{method}{character. Smoothing parameter estimation method; see:
?mgcv::gam}

\item{optimizer}{character. Method to optimize smoothing parameter; see:
?mgcv::gam}

\item{control}{control parameters for loess fits; see: ?loess.control}

\item{message}{Option to print message indicating function progress}

\item{...}{other arguments passed to \code{mgcv::gam}.}
}
\value{
anchor rts data frame with updated weights.
}
\description{
Helper function for \code{\link{fit_gam}} & \code{\link{fit_loess}}. It
filters the set of ordered pairs using the residuals calculated from
multiple GAM / loess fits.
}
