\name{exptable}
\alias{exptable}
\docType{data}
\title{Sample table for the generation of a database of standards (LCMS)}
\description{An example of a table used to construct a database of
  standards. This particular table is used to obtain object \code{LCDBtest}.}
\usage{data(exptable)}
\format{
  \code{exptable} is a \code{data.frame} summarizing information on the
  chemical standards used for creating a database.
  
  Column description:
  \describe{
    \item{ChemSpiderID}{The Chemspider ID of a specific compound.}
    \item{compound}{A string containing the (human) readable name of the
      compound.} 
    \item{formula}{The formula of the compound.}
    \item{M.ref}{The theoretical value for the observed m/z reference
      ion. This can be, for example, the protonated (de-protonated) molecular
      ion, a known adduct or a characteristic fragment.}
    \item{mz.observed}{The manually validated m/z value of the reference
      ion.} 
    \item{RTman}{The manually validated retention time value for the standard.}
    \item{stdFile}{The name (including the path) of the raw data file of the
      standard.} 
  }
}

\details{
  Mandatory fields are: \code{ChemSpiderID}, \code{mz.observed},
  \code{RTman}, and \code{stdFile}.

  In the current implementation the \code{M.ref} value is not used in the
  creation of the DB. The difference between \code{M.ref} and
  \code{m.observed}, however, could be used to construct the mass error
  surface used during feature annotation. 
 
  The sample table is also an element (\code{Reftable}) of the LCDB list
  generated by \code{createSTDdbLC}.
}
\seealso{\code{\link{createSTDdbLC}}}
\author{Pietro Franceschi}
\keyword{datasets}
