% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdp.R
\name{mdp}
\alias{mdp}
\title{Molecular Degree of Perturbation}
\usage{
mdp(data, pdata, control_lab, directory = "", pathways, print = TRUE,
  measure = c("mean", "median"), std = 2, fraction_genes = 0.25,
  save_tables = TRUE, file_name = "")
}
\arguments{
\item{data}{\code{data frame} of gene expression data with the gene symbols 
in the row names}

\item{pdata}{\code{data frame} of phenodata with a column headed Class and the 
other headed Sample.}

\item{control_lab}{character \code{vector} specifying the control class}

\item{directory}{(optional) character string of output directory}

\item{pathways}{(optional) \code{list} whose names are pathways and elements are 
genes in the pathway. see details section for more information}

\item{print}{set as default to TRUE for pdfs of the sample scores 
to be saved}

\item{measure}{'medan' as default, can change to 'median'.
\code{mean} will select for z-score and \code{median} will select for modified
z-score. (see details)}

\item{std}{\code{numeric} set as default to 2, this governs the thresholding of 
expression data. z-scored expression values with absolute value less than 'std' 
will be set to 0.}

\item{fraction_genes}{\code{numeric} fraction of genes that will contribute to the top perturbed genes. Set as default to 0.25}

\item{save_tables}{Set as default to TRUE. Tables of zscore and gene and 
sample scores will be saved.}

\item{file_name}{(optional) character string that will be added to the saved file names}
}
\value{
A list: zscore, gene_scores, gene_freq, sample_scores, perturbed_genes
\itemize{
\item Z-score - z-score is calculated using the control samples to compute
the average and the standard deviation. The absolute value of this
matrix is taken and values less than the std are set to zero.
This z-score data frame is used to compute the gene and sample scores.
\item Gene scores - mean z-score value for each gene in each class
\item Gene frequency - frequency with which a gene has a non zero z-score 
value in each class
\item Sample scores - list containing sample scores for different genesets.
Sample scores are the sum of the z-scored gene values for each sample,
averaged for the number of genes in that geneset.
\item Perturbed genes - vector of the top fraction of genes that have
higher gene scores in the test classes compared to the control.
\item Pathways - if genesets are provided, they are ranked according to the 
signal-to-noise #' ratio of test sample scores versus control sample scores 
calculated using that geneset.
}
}
\description{
Based on the Molecular Distance to Health, this function calculates scores 
to each sample based on their perturbation from healthy
}
\section{Loading pathways}{

a \code{list} of pathways can be loaded from a .gmt file using the
\code{fgsea} function using \code{fgsea::gmtPathways('gmt.file.location')}
}

\section{Selecting mean or median}{

if \code{median} is selected, the z-score will be calculated using the
median, and the standard deviation will be estimated using the median
 absolute deviation, utilising the \code{mad} function.
}

\examples{
# basic run
mdp(example_data,example_pheno,'baseline')
# run with pathways
pathway_file <- system.file('extdata', 'ReactomePathways.gmt', 
package = 'mdp')
mypathway <- fgsea::gmtPathways(pathway_file) # load a gmt file
mdp(data=example_data,pdata=example_pheno,control_lab='baseline',
pathways=mypathway)
}
