% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Correlation_Regression.R
\name{mbQtlCorHeatmap}
\alias{mbQtlCorHeatmap}
\title{\code{mbQtlCorHeatmap} for making heatmap for snp, taxa rho values}
\usage{
mbQtlCorHeatmap(final_var_long, labels_col = NULL, ...)
}
\arguments{
\item{final_var_long}{the long data frame of rho values created by the \code{taxaSnpCor()} function.}

\item{labels_col}{set to NULL ass default if TRUE, labels will appear on the heatmap.}

\item{...}{all other parameters for pheatmap.}
}
\value{
A data frame of correlations between taxa
}
\description{
This function produces a log heatmap +1 of the correlation rho values across snp, taxa datasets
}
\examples{

data(microbeAbund)
data(SnpFile)
for_all_rsids <- allToAllProduct(SnpFile, microbeAbund)
correlationMicrobes <- coringTaxa(microbeAbund)
taxaSnpCor(for_all_rsids, correlationMicrobes)
final_var_long <- taxaSnpCor(for_all_rsids, correlationMicrobes, probs = c(0.0001, 0.9999))
x <- mbQtlCorHeatmap(final_var_long)

}
\keyword{heatmap}
\keyword{rho}
